/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.elements.RawData;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.ApplicationMessage;
import org.eclipse.californium.scandium.dtls.CertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.ChangeCipherSpecMessage;
import org.eclipse.californium.scandium.dtls.ClientHandshaker;
import org.eclipse.californium.scandium.dtls.ClientHello;
import org.eclipse.californium.scandium.dtls.DTLSFlight;
import org.eclipse.californium.scandium.dtls.DTLSMessage;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.Finished;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.HelloVerifyRequest;
import org.eclipse.californium.scandium.dtls.MaxFragmentLengthExtension;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.ServerHello;
import org.eclipse.californium.scandium.dtls.SessionListener;

public class ResumingClientHandshaker
extends ClientHandshaker {
    private static final Logger LOGGER = Logger.getLogger(ResumingClientHandshaker.class.getName());
    private boolean fullHandshake = false;
    private DTLSFlight lastFlight;

    public ResumingClientHandshaker(RawData message, DTLSSession session, SessionListener sessionListener, DtlsConnectorConfig config, int maxTransmissionUnit) throws HandshakeException {
        super(message, session, sessionListener, config, maxTransmissionUnit);
        if (session.getSessionIdentifier() == null) {
            throw new IllegalArgumentException("Session must contain the ID of the session to resume");
        }
    }

    @Override
    protected synchronized DTLSFlight doProcessMessage(DTLSMessage message) throws HandshakeException, GeneralSecurityException {
        if (this.fullHandshake) {
            return super.doProcessMessage(message);
        }
        if (this.lastFlight != null) {
            LOGGER.log(Level.FINER, "Received server's [{0}] FINISHED message again, retransmitting last flight...", message.getPeer());
            return this.lastFlight;
        }
        DTLSFlight flight = null;
        if (LOGGER.isLoggable(Level.FINE)) {
            StringBuffer msg = new StringBuffer();
            msg.append(String.format("Processing %s message from peer [%s]", new Object[]{message.getContentType(), message.getPeer()}));
            if (LOGGER.isLoggable(Level.FINEST)) {
                msg.append(":\n").append(message);
            }
            LOGGER.fine(msg.toString());
        }
        switch (message.getContentType()) {
            case CHANGE_CIPHER_SPEC: {
                this.calculateKeys(this.session.getMasterSecret());
                this.setCurrentReadState();
                LOGGER.log(Level.FINE, "Processed {1} message from peer [{0}]", new Object[]{message.getPeer(), message.getContentType()});
                break;
            }
            case HANDSHAKE: {
                HandshakeMessage handshakeMsg = (HandshakeMessage)message;
                switch (handshakeMsg.getMessageType()) {
                    case HELLO_VERIFY_REQUEST: {
                        flight = this.receivedHelloVerifyRequest((HelloVerifyRequest)message);
                        break;
                    }
                    case SERVER_HELLO: {
                        ServerHello serverHello = (ServerHello)message;
                        if (!this.session.getSessionIdentifier().equals(serverHello.getSessionId())) {
                            LOGGER.log(Level.FINER, "Server [{0}] refuses to resume session [{1}], performing full handshake instead...", new Object[]{serverHello.getPeer(), this.session.getSessionIdentifier()});
                            this.fullHandshake = true;
                            super.receivedServerHello(serverHello);
                            break;
                        }
                        if (!serverHello.getCompressionMethod().equals((Object)this.session.getCompressionMethod())) {
                            throw new HandshakeException("Server wants to change compression method in resumed session", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER, serverHello.getPeer()));
                        }
                        if (!serverHello.getCipherSuite().equals((Object)this.session.getCipherSuite())) {
                            throw new HandshakeException("Server wants to change cipher suite in resumed session", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER, serverHello.getPeer()));
                        }
                        this.serverHello = serverHello;
                        this.serverRandom = serverHello.getRandom();
                        break;
                    }
                    case FINISHED: {
                        flight = this.receivedServerFinished((Finished)handshakeMsg);
                        break;
                    }
                    default: {
                        throw new HandshakeException(String.format("Received unexpected handshake message [%s] from peer %s", new Object[]{handshakeMsg.getMessageType(), handshakeMsg.getPeer()}), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNEXPECTED_MESSAGE, handshakeMsg.getPeer()));
                    }
                }
                this.incrementNextReceiveSeq();
                LOGGER.log(Level.FINE, "Processed {1} message with sequence no [{2}] from peer [{0}]", new Object[]{handshakeMsg.getPeer(), handshakeMsg.getMessageType(), handshakeMsg.getMessageSeq()});
                break;
            }
            default: {
                throw new HandshakeException(String.format("Received unexpected message [%s] from peer %s", new Object[]{message.getContentType(), message.getPeer()}), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, message.getPeer()));
            }
        }
        return flight;
    }

    private DTLSFlight receivedServerFinished(Finished message) throws HandshakeException {
        if (this.lastFlight != null) {
            return null;
        }
        DTLSFlight flight = new DTLSFlight(this.getSession());
        this.md.update(this.clientHello.toByteArray());
        this.md.update(this.serverHello.getRawMessage());
        MessageDigest mdWithServerFinish = null;
        try {
            mdWithServerFinish = (MessageDigest)this.md.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new HandshakeException("Cannot create FINISHED message hash", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, message.getPeer()));
        }
        mdWithServerFinish.update(message.getRawMessage());
        this.handshakeHash = this.md.digest();
        message.verifyData(this.session.getMasterSecret(), false, this.handshakeHash);
        ChangeCipherSpecMessage changeCipherSpecMessage = new ChangeCipherSpecMessage(message.getPeer());
        flight.addMessage(this.wrapMessage(changeCipherSpecMessage));
        this.setCurrentWriteState();
        this.handshakeHash = mdWithServerFinish.digest();
        Finished finished = new Finished(this.session.getMasterSecret(), this.isClient, this.handshakeHash, message.getPeer());
        flight.addMessage(this.wrapMessage(finished));
        ApplicationMessage applicationMessage = new ApplicationMessage(this.message.getBytes(), message.getPeer());
        flight.addMessage(this.wrapMessage(applicationMessage));
        this.state = HandshakeType.FINISHED.getCode();
        flight.setRetransmissionNeeded(false);
        this.lastFlight = flight;
        this.sessionEstablished();
        return flight;
    }

    @Override
    public DTLSFlight getStartHandshakeMessage() throws HandshakeException {
        this.handshakeStarted();
        ClientHello message = new ClientHello(new ProtocolVersion(), new SecureRandom(), this.session, (List<CertificateTypeExtension.CertificateType>)this.supportedClientCertificateTypes, this.supportedServerCertificateTypes);
        this.clientRandom = message.getRandom();
        message.addCipherSuite(this.session.getCipherSuite());
        message.addCompressionMethod(this.session.getCompressionMethod());
        if (this.maxFragmentLengthCode != null) {
            MaxFragmentLengthExtension ext = new MaxFragmentLengthExtension(this.maxFragmentLengthCode);
            message.addExtension(ext);
            LOGGER.log(Level.FINE, "Indicating max. fragment length [{0}] to server [{1}]", new Object[]{this.maxFragmentLengthCode, this.getPeerAddress()});
        }
        this.state = message.getMessageType().getCode();
        this.clientHello = message;
        DTLSFlight flight = new DTLSFlight(this.getSession());
        flight.addMessage(this.wrapMessage(message));
        return flight;
    }
}

