/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import org.eclipse.californium.scandium.dtls.ClientKeyExchange;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.util.DatagramReader;
import org.eclipse.californium.scandium.util.DatagramWriter;

public final class PSKClientKeyExchange
extends ClientKeyExchange {
    private static final int IDENTITY_LENGTH_BITS = 16;
    private static final Charset CHAR_SET = Charset.forName("UTF8");
    private final byte[] identityEncoded;
    private final String identity;

    public PSKClientKeyExchange(String identity, InetSocketAddress peerAddress) {
        super(peerAddress);
        this.identityEncoded = identity.getBytes(CHAR_SET);
        this.identity = identity;
    }

    private PSKClientKeyExchange(byte[] identityEncoded, InetSocketAddress peerAddress) {
        super(peerAddress);
        this.identityEncoded = identityEncoded;
        this.identity = new String(identityEncoded, CHAR_SET);
    }

    @Override
    public int getMessageLength() {
        return 2 + this.identityEncoded.length;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\t\tPSK Identity: ").append(this.identity).append("\n");
        return sb.toString();
    }

    @Override
    public byte[] fragmentToByteArray() {
        DatagramWriter writer = new DatagramWriter();
        writer.write(this.identityEncoded.length, 16);
        writer.writeBytes(this.identityEncoded);
        return writer.toByteArray();
    }

    public static HandshakeMessage fromByteArray(byte[] byteArray, InetSocketAddress peerAddress) {
        DatagramReader reader = new DatagramReader(byteArray);
        int length = reader.read(16);
        byte[] identityEncoded = reader.readBytes(length);
        return new PSKClientKeyExchange(identityEncoded, peerAddress);
    }

    public String getIdentity() {
        return this.identity;
    }
}

