/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.util.Arrays;
import org.eclipse.californium.scandium.dtls.ClientKeyExchange;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.cipher.ECDHECryptography;
import org.eclipse.californium.scandium.util.ByteArrayUtils;
import org.eclipse.californium.scandium.util.DatagramReader;
import org.eclipse.californium.scandium.util.DatagramWriter;

public final class ECDHClientKeyExchange
extends ClientKeyExchange {
    protected static final int LENGTH_BITS = 8;
    private final byte[] pointEncoded;

    public ECDHClientKeyExchange(PublicKey clientPublicKey, InetSocketAddress peerAddress) {
        super(peerAddress);
        ECPublicKey publicKey = (ECPublicKey)clientPublicKey;
        ECPoint point = publicKey.getW();
        ECParameterSpec params = publicKey.getParams();
        this.pointEncoded = ECDHECryptography.encodePoint(point, params.getCurve());
    }

    public ECDHClientKeyExchange(byte[] pointEncoded, InetSocketAddress peerAddress) {
        super(peerAddress);
        this.pointEncoded = pointEncoded;
    }

    @Override
    public byte[] fragmentToByteArray() {
        DatagramWriter writer = new DatagramWriter();
        int length = this.pointEncoded.length;
        writer.write(length, 8);
        writer.writeBytes(this.pointEncoded);
        return writer.toByteArray();
    }

    public static HandshakeMessage fromByteArray(byte[] byteArray, InetSocketAddress peerAddress) {
        DatagramReader reader = new DatagramReader(byteArray);
        int length = reader.read(8);
        byte[] pointEncoded = reader.readBytes(length);
        return new ECDHClientKeyExchange(pointEncoded, peerAddress);
    }

    @Override
    public int getMessageLength() {
        return 1 + this.pointEncoded.length;
    }

    public byte[] getEncodedPoint() {
        return Arrays.copyOf(this.pointEncoded, this.pointEncoded.length);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("\t\tDiffie-Hellman public value: ");
        sb.append(ByteArrayUtils.toHexString(this.pointEncoded));
        sb.append("\n");
        return sb.toString();
    }
}

