/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.auth;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PublicKey;
import java.util.Arrays;
import org.eclipse.californium.scandium.util.Base64;

public class RawPublicKeyIdentity
implements Principal {
    private static final int BASE_64_ENCODING_OPTIONS = 81;
    private String niUri;
    private final PublicKey publicKey;

    public RawPublicKeyIdentity(PublicKey key) {
        if (key == null) {
            throw new NullPointerException("Public key must not be null");
        }
        this.publicKey = key;
        this.createNamedInformationUri(this.publicKey.getEncoded());
    }

    private void createNamedInformationUri(byte[] subjectPublicKeyInfo) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(subjectPublicKeyInfo);
            byte[] digest = md.digest();
            String base64urlDigest = Base64.encodeBytes(digest, 81);
            StringBuffer b = new StringBuffer("ni:///sha-256;").append(base64urlDigest);
            this.niUri = b.toString();
        }
        catch (IOException | NoSuchAlgorithmException exception) {
            // empty catch block
        }
    }

    @Override
    public final String getName() {
        return this.niUri;
    }

    public final PublicKey getKey() {
        return this.publicKey;
    }

    public final byte[] getSubjectInfo() {
        return this.publicKey.getEncoded();
    }

    @Override
    public String toString() {
        return new StringBuffer("RawPublicKey Identity [").append(this.niUri).append("]").toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.publicKey == null ? 0 : this.getSubjectInfo().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RawPublicKeyIdentity)) {
            return false;
        }
        RawPublicKeyIdentity other = (RawPublicKeyIdentity)obj;
        return !(this.publicKey == null ? other.publicKey != null : !Arrays.equals(this.getSubjectInfo(), other.getSubjectInfo()));
    }
}

