/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.pskstore;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.californium.scandium.dtls.pskstore.PskStore;

public class InMemoryPskStore
implements PskStore {
    private Map<String, byte[]> keys = new ConcurrentHashMap<String, byte[]>();
    private Map<InetSocketAddress, String> knownPeers = new ConcurrentHashMap<InetSocketAddress, String>();

    @Override
    public byte[] getKey(String identity) {
        byte[] key = this.keys.get(identity);
        if (key == null) {
            return null;
        }
        return Arrays.copyOf(key, key.length);
    }

    public void setKey(String identity, byte[] key) {
        this.keys.put(identity, key);
    }

    public void addKnownPeer(InetSocketAddress peerAddress, String identity, byte[] key) {
        this.knownPeers.put(peerAddress, identity);
        this.keys.put(identity, key);
    }

    @Override
    public String getIdentity(InetSocketAddress inetAddress) {
        return this.knownPeers.get(inetAddress);
    }
}

