/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.cipher;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.scandium.util.DatagramReader;
import org.eclipse.californium.scandium.util.DatagramWriter;

public enum CipherSuite {
    TLS_NULL_WITH_NULL_NULL("NULL", 0, KeyExchangeAlgorithm.NULL, BulkCipherAlgorithm.NULL, MACAlgorithm.NULL, PRFAlgorithm.TLS_PRF_SHA256, CipherType.NULL),
    TLS_PSK_WITH_AES_128_CBC_SHA256("AES/CBC/NoPadding", 174, KeyExchangeAlgorithm.PSK, BulkCipherAlgorithm.AES_128, MACAlgorithm.HMAC_SHA256, PRFAlgorithm.TLS_PRF_SHA256, CipherType.BLOCK),
    TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256("AES/CBC/NoPadding", 49187, KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN, BulkCipherAlgorithm.AES_128, MACAlgorithm.HMAC_SHA256, PRFAlgorithm.TLS_PRF_SHA256, CipherType.BLOCK),
    TLS_PSK_WITH_AES_128_CCM_8("CCM", 49320, KeyExchangeAlgorithm.PSK, BulkCipherAlgorithm.AES_128, MACAlgorithm.NULL, PRFAlgorithm.TLS_PRF_SHA256, CipherType.AEAD),
    TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8("CCM", 49326, KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN, BulkCipherAlgorithm.AES_128, MACAlgorithm.NULL, PRFAlgorithm.TLS_PRF_SHA256, CipherType.AEAD);

    private static final Logger LOGGER;
    private static final int CIPHER_SUITE_BITS = 16;
    private String transformation;
    private int code;
    private KeyExchangeAlgorithm keyExchange;
    private BulkCipherAlgorithm bulkCipher;
    private MACAlgorithm macAlgorithm;
    private PRFAlgorithm pseudoRandomFunction;
    private CipherType cipherType;

    private CipherSuite(String transformation, int code, KeyExchangeAlgorithm keyExchange, BulkCipherAlgorithm bulkCipher, MACAlgorithm macAlgorithm, PRFAlgorithm prf, CipherType cipherType) {
        this.transformation = transformation;
        this.code = code;
        this.keyExchange = keyExchange;
        this.bulkCipher = bulkCipher;
        this.macAlgorithm = macAlgorithm;
        this.pseudoRandomFunction = prf;
        this.cipherType = cipherType;
    }

    public String getTransformation() {
        return this.transformation;
    }

    public int getCode() {
        return this.code;
    }

    public KeyExchangeAlgorithm getKeyExchange() {
        return this.keyExchange;
    }

    public BulkCipherAlgorithm getBulkCipher() {
        return this.bulkCipher;
    }

    public int getMacLength() {
        return this.macAlgorithm.getOutputLength();
    }

    public int getMacKeyLength() {
        return this.macAlgorithm.getKeyLength();
    }

    public String getMacName() {
        return this.macAlgorithm.getName();
    }

    public int getRecordIvLength() {
        return this.bulkCipher.getRecordIvLength();
    }

    public int getFixedIvLength() {
        return this.bulkCipher.getFixedIvLength();
    }

    public PRFAlgorithm getPseudoRandomFunction() {
        return this.pseudoRandomFunction;
    }

    public CipherType getCipherType() {
        return this.cipherType;
    }

    public int getEncKeyLength() {
        return this.bulkCipher.getKeyLength();
    }

    public static CipherSuite getTypeByCode(int code) {
        switch (code) {
            case 0: {
                return TLS_NULL_WITH_NULL_NULL;
            }
            case 174: {
                return TLS_PSK_WITH_AES_128_CBC_SHA256;
            }
            case 49187: {
                return TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256;
            }
            case 49320: {
                return TLS_PSK_WITH_AES_128_CCM_8;
            }
            case 49326: {
                return TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8;
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Cannot resolve cipher suite code [{0}]", Integer.toHexString(code));
        }
        return null;
    }

    public static CipherSuite getTypeByName(String name) {
        for (CipherSuite suite : CipherSuite.values()) {
            if (!suite.name().equals(name)) continue;
            return suite;
        }
        return null;
    }

    public static byte[] listToByteArray(List<CipherSuite> cipherSuites) {
        DatagramWriter writer = new DatagramWriter();
        for (CipherSuite cipherSuite : cipherSuites) {
            writer.write(cipherSuite.getCode(), 16);
        }
        return writer.toByteArray();
    }

    public static List<CipherSuite> listFromByteArray(byte[] byteArray, int numElements) {
        ArrayList<CipherSuite> cipherSuites = new ArrayList<CipherSuite>();
        DatagramReader reader = new DatagramReader(byteArray);
        for (int i = 0; i < numElements; ++i) {
            int code = reader.read(16);
            CipherSuite cipher = CipherSuite.getTypeByCode(code);
            if (cipher == null) continue;
            cipherSuites.add(cipher);
        }
        return cipherSuites;
    }

    static {
        LOGGER = Logger.getLogger(CipherSuite.class.getCanonicalName());
    }

    public static enum CipherType {
        NULL,
        STREAM,
        BLOCK,
        AEAD;

    }

    public static enum PRFAlgorithm {
        TLS_PRF_SHA256;

    }

    public static enum KeyExchangeAlgorithm {
        NULL,
        DHE_DSS,
        DHE_RSA,
        DH_ANON,
        RSA,
        DH_DSS,
        DH_RSA,
        PSK,
        EC_DIFFIE_HELLMAN;

    }

    public static enum BulkCipherAlgorithm {
        NULL(0, 0, 0),
        B_3DES(24, 4, 8),
        AES_128(16, 4, 16);

        private int keyLength;
        private int fixedIvLength;
        private int recordIvLength;

        private BulkCipherAlgorithm(int key_length, int fixed_iv_length, int recordIvLength) {
            this.keyLength = key_length;
            this.fixedIvLength = fixed_iv_length;
            this.recordIvLength = recordIvLength;
        }

        public int getKeyLength() {
            return this.keyLength;
        }

        public int getFixedIvLength() {
            return this.fixedIvLength;
        }

        public int getRecordIvLength() {
            return this.recordIvLength;
        }
    }

    public static enum MACAlgorithm {
        NULL(null, 0),
        HMAC_MD5("HmacMD5", 16),
        HMAC_SHA1("HmacSHA1", 20),
        HMAC_SHA256("HmacSHA256", 32),
        HMAC_SHA384("HmacSHA384", 48),
        HMAC_SHA512("HmacSHA512", 64);

        private String name;
        private int outputLength;

        private MACAlgorithm(String name, int outputLength) {
            this.name = name;
            this.outputLength = outputLength;
        }

        public String getName() {
            return this.name;
        }

        public int getOutputLength() {
            return this.outputLength;
        }

        public int getKeyLength() {
            return this.outputLength;
        }
    }
}

