/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.ClientCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.CompressionMethod;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.HelloExtension;
import org.eclipse.californium.scandium.dtls.HelloExtensions;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.Random;
import org.eclipse.californium.scandium.dtls.ServerCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.util.ByteArrayUtils;
import org.eclipse.californium.scandium.util.DatagramReader;
import org.eclipse.californium.scandium.util.DatagramWriter;

public class ServerHello
extends HandshakeMessage {
    private static final int VERSION_BITS = 8;
    private static final int RANDOM_BYTES = 32;
    private static final int SESSION_ID_LENGTH_BITS = 8;
    private static final int CIPHER_SUITE_BITS = 16;
    private static final int COMPRESSION_METHOD_BITS = 8;
    private ProtocolVersion serverVersion;
    private Random random;
    private SessionId sessionId;
    private CipherSuite cipherSuite;
    private CompressionMethod compressionMethod;
    private HelloExtensions extensions = null;

    public ServerHello(ProtocolVersion version, Random random, SessionId sessionId, CipherSuite cipherSuite, CompressionMethod compressionMethod, HelloExtensions extensions) {
        if (version == null) {
            throw new NullPointerException("Negotiated protocol version must not be null");
        }
        if (random == null) {
            throw new NullPointerException("ServerHello message must contain a random");
        }
        if (sessionId == null) {
            throw new NullPointerException("ServerHello must be associated with a session ID");
        }
        if (cipherSuite == null) {
            throw new NullPointerException("Negotiated cipher suite must not be null");
        }
        if (compressionMethod == null) {
            throw new NullPointerException("Negotiated compression method must not be null");
        }
        this.serverVersion = version;
        this.random = random;
        this.sessionId = sessionId;
        this.cipherSuite = cipherSuite;
        this.compressionMethod = compressionMethod;
        this.extensions = extensions;
    }

    @Override
    public byte[] fragmentToByteArray() {
        DatagramWriter writer = new DatagramWriter();
        writer.write(this.serverVersion.getMajor(), 8);
        writer.write(this.serverVersion.getMinor(), 8);
        writer.writeBytes(this.random.getRandomBytes());
        writer.write(this.sessionId.length(), 8);
        writer.writeBytes(this.sessionId.getSessionId());
        writer.write(this.cipherSuite.getCode(), 16);
        writer.write(this.compressionMethod.getCode(), 8);
        if (this.extensions != null) {
            writer.writeBytes(this.extensions.toByteArray());
        }
        return writer.toByteArray();
    }

    public static HandshakeMessage fromByteArray(byte[] byteArray) throws HandshakeException {
        DatagramReader reader = new DatagramReader(byteArray);
        int major = reader.read(8);
        int minor = reader.read(8);
        ProtocolVersion version = new ProtocolVersion(major, minor);
        Random random = new Random(reader.readBytes(32));
        int sessionIdLength = reader.read(8);
        SessionId sessionId = new SessionId(reader.readBytes(sessionIdLength));
        int code = reader.read(16);
        CipherSuite cipherSuite = CipherSuite.getTypeByCode(code);
        if (cipherSuite == null) {
            throw new HandshakeException(String.format("Server selected unknown cipher suite [%s]", Integer.toHexString(code)), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE));
        }
        if (cipherSuite == CipherSuite.TLS_NULL_WITH_NULL_NULL) {
            throw new HandshakeException("Server tries to negotiate NULL cipher suite", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE));
        }
        CompressionMethod compressionMethod = CompressionMethod.getMethodByCode(reader.read(8));
        byte[] bytesLeft = reader.readBytesLeft();
        HelloExtensions extensions = null;
        if (bytesLeft.length > 0) {
            extensions = HelloExtensions.fromByteArray(bytesLeft);
        }
        return new ServerHello(version, random, sessionId, cipherSuite, compressionMethod, extensions);
    }

    @Override
    public HandshakeType getMessageType() {
        return HandshakeType.SERVER_HELLO;
    }

    @Override
    public int getMessageLength() {
        int extensionsLength = this.extensions == null || this.extensions.isEmpty() ? 0 : 2 + this.extensions.getLength();
        return 38 + this.sessionId.length() + extensionsLength;
    }

    public ProtocolVersion getServerVersion() {
        return this.serverVersion;
    }

    public Random getRandom() {
        return this.random;
    }

    public SessionId getSessionId() {
        return this.sessionId;
    }

    public CipherSuite getCipherSuite() {
        return this.cipherSuite;
    }

    public CompressionMethod getCompressionMethod() {
        return this.compressionMethod;
    }

    public HelloExtensions getExtensions() {
        return this.extensions;
    }

    CertificateTypeExtension.CertificateType getClientCertificateType() {
        ClientCertificateTypeExtension ext;
        CertificateTypeExtension.CertificateType result = CertificateTypeExtension.CertificateType.X_509;
        if (this.extensions != null && (ext = (ClientCertificateTypeExtension)this.extensions.getExtension(HelloExtension.ExtensionType.CLIENT_CERT_TYPE)) != null && !ext.getCertificateTypes().isEmpty()) {
            result = ext.getCertificateTypes().get(0);
        }
        return result;
    }

    CertificateTypeExtension.CertificateType getServerCertificateType() {
        ServerCertificateTypeExtension ext;
        CertificateTypeExtension.CertificateType result = CertificateTypeExtension.CertificateType.X_509;
        if (this.extensions != null && (ext = (ServerCertificateTypeExtension)this.extensions.getExtension(HelloExtension.ExtensionType.SERVER_CERT_TYPE)) != null && !ext.getCertificateTypes().isEmpty()) {
            result = ext.getCertificateTypes().get(0);
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("\t\tServer Version: ").append(this.serverVersion.getMajor()).append(", ").append(this.serverVersion.getMinor());
        sb.append("\n\t\tRandom: \n").append(this.random);
        sb.append("\t\tSession ID Length: ").append(this.sessionId.length());
        if (this.sessionId.length() > 0) {
            sb.append("\n\t\tSession ID: ").append(ByteArrayUtils.toHexString(this.sessionId.getSessionId()));
        }
        sb.append("\n\t\tCipher Suite: ").append((Object)this.cipherSuite);
        sb.append("\n\t\tCompression Method: ").append((Object)this.compressionMethod);
        if (this.extensions != null) {
            sb.append("\n").append(this.extensions);
        }
        return sb.toString();
    }
}

