/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.californium.scandium.auth.PreSharedKeyIdentity;
import org.eclipse.californium.scandium.auth.RawPublicKeyIdentity;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateMessage;
import org.eclipse.californium.scandium.dtls.CertificateRequest;
import org.eclipse.californium.scandium.dtls.CertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.CertificateVerify;
import org.eclipse.californium.scandium.dtls.ChangeCipherSpecMessage;
import org.eclipse.californium.scandium.dtls.ClientCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.ClientHello;
import org.eclipse.californium.scandium.dtls.ClientKeyExchange;
import org.eclipse.californium.scandium.dtls.CompressionMethod;
import org.eclipse.californium.scandium.dtls.DTLSFlight;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.ECDHClientKeyExchange;
import org.eclipse.californium.scandium.dtls.ECDHServerKeyExchange;
import org.eclipse.californium.scandium.dtls.Finished;
import org.eclipse.californium.scandium.dtls.FragmentedHandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.Handshaker;
import org.eclipse.californium.scandium.dtls.HelloExtensions;
import org.eclipse.californium.scandium.dtls.HelloRequest;
import org.eclipse.californium.scandium.dtls.NULLClientKeyExchange;
import org.eclipse.californium.scandium.dtls.PSKClientKeyExchange;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.Random;
import org.eclipse.californium.scandium.dtls.Record;
import org.eclipse.californium.scandium.dtls.ServerCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.ServerHello;
import org.eclipse.californium.scandium.dtls.ServerHelloDone;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.SessionListener;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.SupportedEllipticCurvesExtension;
import org.eclipse.californium.scandium.dtls.SupportedPointFormatsExtension;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.ECDHECryptography;
import org.eclipse.californium.scandium.dtls.pskstore.PskStore;
import org.eclipse.californium.scandium.util.ByteArrayUtils;

public class ServerHandshaker
extends Handshaker {
    private boolean clientAuthenticationRequired = false;
    private PublicKey clientPublicKey;
    private X509Certificate peerCertificate;
    private List<CipherSuite> supportedCipherSuites;
    private List<CertificateTypeExtension.CertificateType> supportedClientCertificateTypes;
    private List<CertificateTypeExtension.CertificateType> supportedServerCertificateTypes;
    protected CertificateMessage clientCertificate = null;
    protected ClientKeyExchange clientKeyExchange;
    protected CertificateVerify certificateVerify = null;
    protected final PskStore pskStore;

    public ServerHandshaker(DTLSSession session, SessionListener sessionListener, DtlsConnectorConfig config) throws HandshakeException {
        this(0, session, sessionListener, config);
    }

    public ServerHandshaker(int initialMessageSequenceNo, DTLSSession session, SessionListener sessionListener, DtlsConnectorConfig config) throws HandshakeException {
        super(false, initialMessageSequenceNo, session, sessionListener, config.getTrustStore(), config.getMaxFragmentLength());
        this.supportedCipherSuites = Arrays.asList(config.getSupportedCipherSuites());
        this.pskStore = config.getPskStore();
        this.privateKey = config.getPrivateKey();
        this.certificates = config.getCertificateChain();
        this.publicKey = config.getPublicKey();
        this.clientAuthenticationRequired = config.isClientAuthenticationRequired();
        this.supportedClientCertificateTypes = new ArrayList<CertificateTypeExtension.CertificateType>();
        this.supportedClientCertificateTypes.add(CertificateTypeExtension.CertificateType.RAW_PUBLIC_KEY);
        if (this.rootCertificates != null) {
            this.supportedClientCertificateTypes.add(CertificateTypeExtension.CertificateType.X_509);
        }
        this.supportedServerCertificateTypes = new ArrayList<CertificateTypeExtension.CertificateType>();
        if (this.privateKey != null && this.publicKey != null) {
            if (config.isSendRawKey()) {
                this.supportedServerCertificateTypes.add(CertificateTypeExtension.CertificateType.RAW_PUBLIC_KEY);
            }
            if (this.certificates != null) {
                this.supportedServerCertificateTypes.add(CertificateTypeExtension.CertificateType.X_509);
            }
        }
    }

    @Override
    protected synchronized DTLSFlight doProcessMessage(Record record) throws HandshakeException, GeneralSecurityException {
        if (this.lastFlight != null) {
            LOGGER.log(Level.FINER, "Received client's ({0}) FINISHED message again, retransmitting last flight...", this.getPeerAddress());
            return this.lastFlight;
        }
        DTLSFlight flight = null;
        if (!this.processMessageNext(record)) {
            return flight;
        }
        LOGGER.log(Level.FINER, "Processing DTLS record from peer [{0}]:\n{1}", new Object[]{this.getPeerAddress(), record});
        block0 : switch (record.getType()) {
            case CHANGE_CIPHER_SPEC: {
                record.getFragment();
                this.setCurrentReadState();
                break;
            }
            case HANDSHAKE: {
                HandshakeMessage fragment = (HandshakeMessage)record.getFragment();
                if (fragment instanceof FragmentedHandshakeMessage) {
                    if ((fragment = this.handleFragmentation((FragmentedHandshakeMessage)fragment)) == null) break;
                    record.setFragment(fragment);
                }
                switch (fragment.getMessageType()) {
                    case CLIENT_HELLO: {
                        flight = this.receivedClientHello((ClientHello)fragment);
                        break block0;
                    }
                    case CERTIFICATE: {
                        this.receivedClientCertificate((CertificateMessage)fragment);
                        break block0;
                    }
                    case CLIENT_KEY_EXCHANGE: {
                        switch (this.keyExchange) {
                            case PSK: {
                                byte[] premasterSecret = this.receivedClientKeyExchange((PSKClientKeyExchange)fragment);
                                this.generateKeys(premasterSecret);
                                break;
                            }
                            case EC_DIFFIE_HELLMAN: {
                                byte[] premasterSecret = this.receivedClientKeyExchange((ECDHClientKeyExchange)fragment);
                                this.generateKeys(premasterSecret);
                                break;
                            }
                            case NULL: {
                                byte[] premasterSecret = this.receivedClientKeyExchange((NULLClientKeyExchange)fragment);
                                this.generateKeys(premasterSecret);
                                break;
                            }
                            default: {
                                AlertMessage alertMessage = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE);
                                throw new HandshakeException("Unknown key exchange algorithm: " + (Object)((Object)this.keyExchange), alertMessage);
                            }
                        }
                        this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, this.clientKeyExchange.getRawMessage());
                        break block0;
                    }
                    case CERTIFICATE_VERIFY: {
                        this.receivedCertificateVerify((CertificateVerify)fragment);
                        break block0;
                    }
                    case FINISHED: {
                        flight = this.receivedClientFinished((Finished)fragment);
                        break block0;
                    }
                }
                AlertMessage alertMessage = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNEXPECTED_MESSAGE);
                throw new HandshakeException("Server received unexpected handshake message:\n" + fragment.toString(), alertMessage);
            }
            default: {
                AlertMessage alertMessage = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE);
                throw new HandshakeException("Server received not supported record:\n" + record.toString(), alertMessage);
            }
        }
        if (flight == null) {
            Record nextMessage = null;
            for (Record queuedMessage : this.queuedMessages) {
                if (!this.processMessageNext(queuedMessage)) continue;
                nextMessage = queuedMessage;
                break;
            }
            if (nextMessage != null) {
                flight = this.processMessage(nextMessage);
            }
        }
        LOGGER.log(Level.FINE, "Processed DTLS record from peer [{0}]:\n{1}", new Object[]{this.getPeerAddress(), record});
        return flight;
    }

    private void receivedClientCertificate(CertificateMessage message) throws HandshakeException {
        if (this.clientCertificate != null && this.clientCertificate.getMessageSeq() == message.getMessageSeq()) {
            return;
        }
        this.clientCertificate = message;
        this.clientCertificate.verifyCertificate(this.rootCertificates);
        this.clientPublicKey = this.clientCertificate.getPublicKey();
        if (message.getCertificateChain() != null) {
            this.peerCertificate = (X509Certificate)message.getCertificateChain()[0];
        }
        this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, this.clientCertificate.getRawMessage());
    }

    private void receivedCertificateVerify(CertificateVerify message) throws HandshakeException {
        this.certificateVerify = message;
        message.verifySignature(this.clientPublicKey, this.handshakeMessages);
        if (this.peerCertificate != null) {
            this.session.setPeerIdentity(this.peerCertificate.getSubjectX500Principal());
        } else {
            this.session.setPeerIdentity(new RawPublicKeyIdentity(this.clientPublicKey));
        }
        this.session.setPeerRawPublicKey(this.clientPublicKey);
    }

    private DTLSFlight receivedClientFinished(Finished message) throws HandshakeException {
        if (this.lastFlight != null) {
            return null;
        }
        if (this.keyExchange == CipherSuite.KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN && this.clientAuthenticationRequired && (this.clientCertificate == null || this.certificateVerify == null)) {
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE);
            throw new HandshakeException("Client did not send required authentication messages.", alert);
        }
        DTLSFlight flight = new DTLSFlight(this.getSession());
        if (this.clientCertificate != null) {
            this.md.update(this.clientCertificate.getRawMessage());
        }
        this.md.update(this.clientKeyExchange.getRawMessage());
        if (this.certificateVerify != null) {
            this.md.update(this.certificateVerify.getRawMessage());
        }
        MessageDigest mdWithClientFinished = null;
        try {
            mdWithClientFinished = (MessageDigest)this.md.clone();
            mdWithClientFinished.update(message.toByteArray());
        }
        catch (CloneNotSupportedException e) {
            LOGGER.log(Level.SEVERE, "Cannot compute digest for server's Finish handshake message", e);
        }
        byte[] handshakeHash = this.md.digest();
        message.verifyData(this.getMasterSecret(), true, handshakeHash);
        ChangeCipherSpecMessage changeCipherSpecMessage = new ChangeCipherSpecMessage();
        flight.addMessage(this.wrapMessage(changeCipherSpecMessage));
        this.setCurrentWriteState();
        handshakeHash = mdWithClientFinished.digest();
        Finished finished = new Finished(this.getMasterSecret(), this.isClient, handshakeHash);
        flight.addMessage(this.wrapMessage(finished));
        this.state = HandshakeType.FINISHED.getCode();
        this.session.setActive(true);
        flight.setRetransmissionNeeded(false);
        this.lastFlight = flight;
        this.sessionEstablished();
        return flight;
    }

    private DTLSFlight receivedClientHello(ClientHello message) throws HandshakeException {
        this.handshakeStarted();
        DTLSFlight flight = new DTLSFlight(this.getSession());
        this.md.update(message.getRawMessage());
        this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, message.getRawMessage());
        ProtocolVersion serverVersion = this.negotiateProtocolVersion(message.getClientVersion());
        this.clientRandom = message.getRandom();
        this.serverRandom = new Random(new SecureRandom());
        SessionId sessionId = new SessionId();
        this.session.setSessionIdentifier(sessionId);
        CipherSuite cipherSuite = this.negotiateCipherSuite(message.getCipherSuites());
        this.setCipherSuite(cipherSuite);
        CompressionMethod compressionMethod = CompressionMethod.NULL;
        this.setCompressionMethod(compressionMethod);
        HelloExtensions serverHelloExtensions = new HelloExtensions();
        if (this.supportedCipherSuites.contains((Object)CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8)) {
            ServerCertificateTypeExtension serverCertificateTypeExtension;
            ClientCertificateTypeExtension clientCertificateTypeExtension = message.getClientCertificateTypeExtension();
            if (clientCertificateTypeExtension != null) {
                CertificateTypeExtension.CertificateType certType = this.negotiateCertificateType(clientCertificateTypeExtension, this.supportedClientCertificateTypes);
                ClientCertificateTypeExtension ext1 = new ClientCertificateTypeExtension(false);
                ext1.addCertificateType(certType);
                serverHelloExtensions.addExtension(ext1);
                if (certType == CertificateTypeExtension.CertificateType.RAW_PUBLIC_KEY) {
                    this.session.setReceiveRawPublicKey(true);
                }
            }
            if ((serverCertificateTypeExtension = message.getServerCertificateTypeExtension()) != null) {
                CertificateTypeExtension.CertificateType certType = this.negotiateCertificateType(serverCertificateTypeExtension, this.supportedServerCertificateTypes);
                ServerCertificateTypeExtension ext2 = new ServerCertificateTypeExtension(false);
                ext2.addCertificateType(certType);
                serverHelloExtensions.addExtension(ext2);
                if (certType == CertificateTypeExtension.CertificateType.RAW_PUBLIC_KEY) {
                    this.session.setSendRawPublicKey(true);
                }
            }
        }
        if (this.keyExchange == CipherSuite.KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN) {
            List<SupportedPointFormatsExtension.ECPointFormat> formats = Arrays.asList(SupportedPointFormatsExtension.ECPointFormat.UNCOMPRESSED);
            SupportedPointFormatsExtension ext3 = new SupportedPointFormatsExtension(formats);
            serverHelloExtensions.addExtension(ext3);
        }
        ServerHello serverHello = new ServerHello(serverVersion, this.serverRandom, sessionId, cipherSuite, compressionMethod, serverHelloExtensions);
        flight.addMessage(this.wrapMessage(serverHello));
        this.md.update(serverHello.toByteArray());
        this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, serverHello.toByteArray());
        CertificateMessage certificateMessage = null;
        switch (this.keyExchange) {
            case EC_DIFFIE_HELLMAN: {
                if (this.session.sendRawPublicKey()) {
                    certificateMessage = new CertificateMessage(this.publicKey.getEncoded());
                    break;
                }
                certificateMessage = new CertificateMessage(this.certificates);
                break;
            }
        }
        if (certificateMessage != null) {
            flight.addMessage(this.wrapMessage(certificateMessage));
            this.md.update(certificateMessage.toByteArray());
            this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, certificateMessage.toByteArray());
        }
        HandshakeMessage serverKeyExchange = null;
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = null;
        switch (this.keyExchange) {
            case EC_DIFFIE_HELLMAN: {
                signatureAndHashAlgorithm = new SignatureAndHashAlgorithm(CertificateRequest.HashAlgorithm.SHA256, CertificateRequest.SignatureAlgorithm.ECDSA);
                int namedCurveId = this.negotiateNamedCurve(message.getSupportedEllipticCurvesExtension());
                this.ecdhe = new ECDHECryptography(namedCurveId);
                serverKeyExchange = new ECDHServerKeyExchange(signatureAndHashAlgorithm, this.ecdhe, this.privateKey, this.clientRandom, this.serverRandom, namedCurveId);
                break;
            }
            case PSK: {
                break;
            }
        }
        if (serverKeyExchange != null) {
            flight.addMessage(this.wrapMessage(serverKeyExchange));
            this.md.update(serverKeyExchange.toByteArray());
            this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, serverKeyExchange.toByteArray());
        }
        if (this.clientAuthenticationRequired && signatureAndHashAlgorithm != null) {
            CertificateRequest certificateRequest = new CertificateRequest();
            certificateRequest.addCertificateType(CertificateRequest.ClientCertificateType.ECDSA_SIGN);
            certificateRequest.addSignatureAlgorithm(new SignatureAndHashAlgorithm(signatureAndHashAlgorithm.getHash(), signatureAndHashAlgorithm.getSignature()));
            certificateRequest.addCertificateAuthorities(this.rootCertificates);
            flight.addMessage(this.wrapMessage(certificateRequest));
            this.md.update(certificateRequest.toByteArray());
            this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, certificateRequest.toByteArray());
        }
        ServerHelloDone serverHelloDone = new ServerHelloDone();
        flight.addMessage(this.wrapMessage(serverHelloDone));
        this.md.update(serverHelloDone.toByteArray());
        this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, serverHelloDone.toByteArray());
        return flight;
    }

    private byte[] receivedClientKeyExchange(ECDHClientKeyExchange message) {
        this.clientKeyExchange = message;
        byte[] premasterSecret = this.ecdhe.getSecret(message.getEncodedPoint()).getEncoded();
        return premasterSecret;
    }

    private byte[] receivedClientKeyExchange(PSKClientKeyExchange message) throws HandshakeException {
        this.clientKeyExchange = message;
        String identity = message.getIdentity();
        byte[] psk = this.pskStore.getKey(identity);
        LOGGER.log(Level.FINER, "Client [{0}] uses PSK identity [{1}]", new Object[]{this.getPeerAddress(), identity});
        if (psk == null) {
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE);
            throw new HandshakeException("No pre-shared secret found for identity: " + identity, alert);
        }
        this.session.setPeerIdentity(new PreSharedKeyIdentity(identity));
        this.session.setPskIdentity(identity);
        return this.generatePremasterSecretFromPSK(psk);
    }

    private byte[] receivedClientKeyExchange(NULLClientKeyExchange message) {
        this.clientKeyExchange = message;
        return new byte[0];
    }

    @Override
    public DTLSFlight getStartHandshakeMessage() throws HandshakeException {
        HelloRequest helloRequest = new HelloRequest();
        DTLSFlight flight = new DTLSFlight(this.getSession());
        flight.addMessage(this.wrapMessage(helloRequest));
        return flight;
    }

    private ProtocolVersion negotiateProtocolVersion(ProtocolVersion clientVersion) throws HandshakeException {
        ProtocolVersion version = new ProtocolVersion();
        if (clientVersion.compareTo(version) >= 0) {
            return new ProtocolVersion();
        }
        AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.PROTOCOL_VERSION);
        throw new HandshakeException("The server only supports DTLS v1.2", alert);
    }

    private CipherSuite negotiateCipherSuite(List<CipherSuite> cipherSuites) throws HandshakeException {
        for (CipherSuite cipherSuite : cipherSuites) {
            if (cipherSuite == CipherSuite.TLS_NULL_WITH_NULL_NULL || !this.supportedCipherSuites.contains((Object)cipherSuite)) continue;
            return cipherSuite;
        }
        AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE);
        throw new HandshakeException("Client proposed unsupported cipher suites only", alert);
    }

    private int negotiateNamedCurve(SupportedEllipticCurvesExtension extension) throws HandshakeException {
        if (extension != null) {
            for (Integer curveID : extension.getEllipticCurveList()) {
                if (ECDHServerKeyExchange.NAMED_CURVE_PARAMETERS.get(curveID) == null) continue;
                return curveID;
            }
        } else {
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE);
            throw new HandshakeException("The client did not provide the supported elliptic curves extension although ECC cipher suite chosen.", alert);
        }
        AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE);
        throw new HandshakeException("No proposed elliptic curve supported.", alert);
    }

    private CertificateTypeExtension.CertificateType negotiateCertificateType(CertificateTypeExtension extension, List<CertificateTypeExtension.CertificateType> supportedTypes) throws HandshakeException {
        for (CertificateTypeExtension.CertificateType preferredType : extension.getCertificateTypes()) {
            if (!supportedTypes.contains((Object)preferredType)) continue;
            return preferredType;
        }
        throw new HandshakeException("No supported certificate type found", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNSUPPORTED_CERTIFICATE));
    }
}

