/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Date;
import org.eclipse.californium.scandium.util.ByteArrayUtils;

public class Random {
    private byte[] randomBytes;

    public Random() {
        this(new SecureRandom());
    }

    public Random(SecureRandom generator) {
        int gmtUnixTime = (int)(System.currentTimeMillis() / 1000L);
        this.randomBytes = new byte[32];
        generator.nextBytes(this.randomBytes);
        this.randomBytes[0] = (byte)(gmtUnixTime >> 24);
        this.randomBytes[1] = (byte)(gmtUnixTime >> 16);
        this.randomBytes[2] = (byte)(gmtUnixTime >> 8);
        this.randomBytes[3] = (byte)gmtUnixTime;
    }

    public Random(byte[] randomBytes) {
        if (randomBytes == null) {
            throw new NullPointerException("Random bytes must not be null");
        }
        if (randomBytes.length != 32) {
            throw new IllegalArgumentException("Random bytes array's length must be 32");
        }
        this.randomBytes = randomBytes;
    }

    public byte[] getRandomBytes() {
        return Arrays.copyOf(this.randomBytes, this.randomBytes.length);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        byte b0 = this.randomBytes[0];
        byte b1 = this.randomBytes[1];
        byte b2 = this.randomBytes[2];
        byte b3 = this.randomBytes[3];
        long gmtUnixTime = (0xFF & b0) << 24 | (0xFF & b1) << 16 | (0xFF & b2) << 8 | 0xFF & b3;
        Date date = new Date(gmtUnixTime * 1000L);
        sb.append("\t\t\tGMT Unix Time: " + date.toString() + "\n");
        byte[] rand = Arrays.copyOfRange(this.randomBytes, 4, 32);
        sb.append("\t\t\tRandom Bytes: " + ByteArrayUtils.toHexString(rand) + "\n");
        return sb.toString();
    }
}

