/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.SessionStore;
import org.eclipse.californium.scandium.util.LeastRecentlyUsedCache;

public class InMemorySessionStore
extends LeastRecentlyUsedCache<InetSocketAddress, DTLSSession>
implements SessionStore {
    private static final Logger LOG = Logger.getLogger(InMemorySessionStore.class.getName());

    public InMemorySessionStore() {
    }

    public InMemorySessionStore(int capacity, long threshold) {
        super(capacity, threshold);
        LOG.log(Level.CONFIG, "Created new InMemorySessionStore [capacity: {0}, session expiration threshold: {1}s]", new Object[]{capacity, threshold});
    }

    @Override
    public final synchronized boolean put(DTLSSession session) {
        if (session != null) {
            return this.put(session.getPeer(), session);
        }
        return false;
    }

    @Override
    public final synchronized DTLSSession find(final SessionId id) {
        if (id == null) {
            return null;
        }
        return this.find(new LeastRecentlyUsedCache.Predicate<DTLSSession>(){

            @Override
            public boolean accept(DTLSSession session) {
                return id.equals(session.getSessionIdentifier());
            }
        });
    }

    @Override
    public void update(DTLSSession session) {
    }
}

