/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.scandium.util.DatagramReader;
import org.eclipse.californium.scandium.util.DatagramWriter;

public enum CompressionMethod {
    NULL(0);

    private static final Logger LOGGER;
    private static final int COMPRESSION_METHOD_BITS = 8;
    private int code;

    private CompressionMethod(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static CompressionMethod getMethodByCode(int code) {
        switch (code) {
            case 0: {
                return NULL;
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Unknown compression method code: " + code);
        }
        return null;
    }

    public static byte[] listToByteArray(List<CompressionMethod> compressionMethods) {
        DatagramWriter writer = new DatagramWriter();
        for (CompressionMethod compressionMethod : compressionMethods) {
            writer.write(compressionMethod.getCode(), 8);
        }
        return writer.toByteArray();
    }

    public static List<CompressionMethod> listFromByteArray(byte[] byteArray, int numElements) {
        ArrayList<CompressionMethod> compressionMethods = new ArrayList<CompressionMethod>();
        DatagramReader reader = new DatagramReader(byteArray);
        for (int i = 0; i < numElements; ++i) {
            int code = reader.read(8);
            CompressionMethod method = CompressionMethod.getMethodByCode(code);
            if (method == null) continue;
            compressionMethods.add(method);
        }
        return compressionMethods;
    }

    static {
        LOGGER = Logger.getLogger(CompressionMethod.class.getCanonicalName());
    }
}

