/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.californium.scandium.dtls.CertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.ClientCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.CompressionMethod;
import org.eclipse.californium.scandium.dtls.Cookie;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.ECDHServerKeyExchange;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.HelloExtension;
import org.eclipse.californium.scandium.dtls.HelloExtensions;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.Random;
import org.eclipse.californium.scandium.dtls.ServerCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.SupportedEllipticCurvesExtension;
import org.eclipse.californium.scandium.dtls.SupportedPointFormatsExtension;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.util.ByteArrayUtils;
import org.eclipse.californium.scandium.util.DatagramReader;
import org.eclipse.californium.scandium.util.DatagramWriter;

public class ClientHello
extends HandshakeMessage {
    private static final int VERSION_BITS = 8;
    private static final int RANDOM_BYTES = 32;
    private static final int SESSION_ID_LENGTH_BITS = 8;
    private static final int COOKIE_LENGTH = 8;
    private static final int CIPHER_SUITS_LENGTH_BITS = 16;
    private static final int COMPRESSION_METHODS_LENGTH_BITS = 8;
    private ProtocolVersion clientVersion = new ProtocolVersion();
    private Random random;
    private SessionId sessionId;
    private Cookie cookie;
    private List<CipherSuite> cipherSuites;
    private List<CompressionMethod> compressionMethods;
    private HelloExtensions extensions = null;

    public ClientHello(ProtocolVersion version, SecureRandom secureRandom, boolean useRawPublicKey) {
        this.clientVersion = version;
        this.random = new Random(secureRandom);
        this.sessionId = new SessionId(new byte[0]);
        this.cookie = new Cookie();
        this.extensions = new HelloExtensions();
        this.cipherSuites = new ArrayList<CipherSuite>();
        this.compressionMethods = new ArrayList<CompressionMethod>();
        List<Integer> curves = Arrays.asList(ECDHServerKeyExchange.NAMED_CURVE_INDEX.get("secp256r1"), ECDHServerKeyExchange.NAMED_CURVE_INDEX.get("secp384r1"), ECDHServerKeyExchange.NAMED_CURVE_INDEX.get("secp521r1"));
        SupportedEllipticCurvesExtension supportedCurvesExtension = new SupportedEllipticCurvesExtension(curves);
        this.extensions.addExtension(supportedCurvesExtension);
        List<SupportedPointFormatsExtension.ECPointFormat> formats = Arrays.asList(SupportedPointFormatsExtension.ECPointFormat.UNCOMPRESSED);
        SupportedPointFormatsExtension supportedPointFormatsExtension = new SupportedPointFormatsExtension(formats);
        this.extensions.addExtension(supportedPointFormatsExtension);
        ClientCertificateTypeExtension clientCertificateType = new ClientCertificateTypeExtension(true);
        if (useRawPublicKey) {
            clientCertificateType.addCertificateType(CertificateTypeExtension.CertificateType.RAW_PUBLIC_KEY);
            clientCertificateType.addCertificateType(CertificateTypeExtension.CertificateType.X_509);
        } else {
            clientCertificateType.addCertificateType(CertificateTypeExtension.CertificateType.X_509);
            clientCertificateType.addCertificateType(CertificateTypeExtension.CertificateType.RAW_PUBLIC_KEY);
        }
        ServerCertificateTypeExtension serverCertificateType = new ServerCertificateTypeExtension(true);
        if (useRawPublicKey) {
            serverCertificateType.addCertificateType(CertificateTypeExtension.CertificateType.RAW_PUBLIC_KEY);
            serverCertificateType.addCertificateType(CertificateTypeExtension.CertificateType.X_509);
        } else {
            serverCertificateType.addCertificateType(CertificateTypeExtension.CertificateType.X_509);
            serverCertificateType.addCertificateType(CertificateTypeExtension.CertificateType.RAW_PUBLIC_KEY);
        }
        this.extensions.addExtension(clientCertificateType);
        this.extensions.addExtension(serverCertificateType);
    }

    public ClientHello(ProtocolVersion version, SecureRandom secureRandom, DTLSSession session) {
        this.clientVersion = version;
        this.random = new Random(secureRandom);
        this.sessionId = session.getSessionIdentifier();
        this.cookie = new Cookie();
        this.addCipherSuite(session.getWriteState().getCipherSuite());
        this.addCompressionMethod(session.getReadState().getCompressionMethod());
    }

    private ClientHello() {
    }

    @Override
    public byte[] fragmentToByteArray() {
        DatagramWriter writer = new DatagramWriter();
        writer.write(this.clientVersion.getMajor(), 8);
        writer.write(this.clientVersion.getMinor(), 8);
        writer.writeBytes(this.random.getRandomBytes());
        writer.write(this.sessionId.length(), 8);
        writer.writeBytes(this.sessionId.getSessionId());
        writer.write(this.cookie.length(), 8);
        writer.writeBytes(this.cookie.getCookie());
        writer.write(this.cipherSuites.size() * 2, 16);
        writer.writeBytes(CipherSuite.listToByteArray(this.cipherSuites));
        writer.write(this.compressionMethods.size(), 8);
        writer.writeBytes(CompressionMethod.listToByteArray(this.compressionMethods));
        if (this.extensions != null) {
            writer.writeBytes(this.extensions.toByteArray());
        }
        return writer.toByteArray();
    }

    public static HandshakeMessage fromByteArray(byte[] byteArray) throws HandshakeException {
        DatagramReader reader = new DatagramReader(byteArray);
        ClientHello result = new ClientHello();
        int major = reader.read(8);
        int minor = reader.read(8);
        result.clientVersion = new ProtocolVersion(major, minor);
        result.random = new Random(reader.readBytes(32));
        int sessionIdLength = reader.read(8);
        result.sessionId = new SessionId(reader.readBytes(sessionIdLength));
        int cookieLength = reader.read(8);
        result.cookie = new Cookie(reader.readBytes(cookieLength));
        int cipherSuitesLength = reader.read(16);
        result.cipherSuites = CipherSuite.listFromByteArray(reader.readBytes(cipherSuitesLength), cipherSuitesLength / 2);
        int compressionMethodsLength = reader.read(8);
        result.compressionMethods = CompressionMethod.listFromByteArray(reader.readBytes(compressionMethodsLength), compressionMethodsLength);
        byte[] bytesLeft = reader.readBytesLeft();
        if (bytesLeft.length > 0) {
            result.extensions = HelloExtensions.fromByteArray(bytesLeft);
        }
        return result;
    }

    @Override
    public HandshakeType getMessageType() {
        return HandshakeType.CLIENT_HELLO;
    }

    @Override
    public int getMessageLength() {
        int extensionsLength = this.extensions == null || this.extensions.isEmpty() ? 0 : 2 + this.extensions.getLength();
        return 39 + this.sessionId.length() + this.cookie.length() + this.cipherSuites.size() * 2 + this.compressionMethods.size() + extensionsLength;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("\t\tVersion: ").append(this.clientVersion.getMajor()).append(", ").append(this.clientVersion.getMinor());
        sb.append("\n\t\tRandom: \n").append(this.random);
        sb.append("\t\tSession ID Length: ").append(this.sessionId.length());
        if (this.sessionId.length() > 0) {
            sb.append("\n\t\tSession ID: ").append(ByteArrayUtils.toHexString(this.sessionId.getSessionId()));
        }
        sb.append("\n\t\tCookie Length: ").append(this.cookie.length());
        if (this.cookie.length() > 0) {
            sb.append("\n\t\tCookie: ").append(ByteArrayUtils.toHexString(this.cookie.getCookie()));
        }
        sb.append("\n\t\tCipher Suites Length: ").append(this.cipherSuites.size() * 2);
        sb.append("\n\t\tCipher Suites (").append(this.cipherSuites.size()).append(" suites)");
        for (CipherSuite cipher : this.cipherSuites) {
            sb.append("\n\t\t\tCipher Suite: ").append((Object)cipher);
        }
        sb.append("\n\t\tCompression Methods Length: ").append(this.compressionMethods.size());
        sb.append("\n\t\tCompression Methods (").append(this.compressionMethods.size()).append(" method)");
        for (CompressionMethod method : this.compressionMethods) {
            sb.append("\n\t\t\tCompression Method: ").append((Object)method);
        }
        if (this.extensions != null) {
            sb.append("\n").append(this.extensions);
        }
        return sb.toString();
    }

    public ProtocolVersion getClientVersion() {
        return this.clientVersion;
    }

    public void setClientVersion(ProtocolVersion clientVersion) {
        this.clientVersion = clientVersion;
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    public SessionId getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(SessionId sessionId) {
        this.sessionId = sessionId;
    }

    public Cookie getCookie() {
        return this.cookie;
    }

    public void setCookie(Cookie cookie) {
        this.cookie = cookie;
    }

    public List<CipherSuite> getCipherSuites() {
        return Collections.unmodifiableList(this.cipherSuites);
    }

    public void setCipherSuits(List<CipherSuite> cipherSuits) {
        this.cipherSuites.addAll(cipherSuits);
    }

    public void addCipherSuite(CipherSuite cipherSuite) {
        if (this.cipherSuites == null) {
            this.cipherSuites = new ArrayList<CipherSuite>();
        }
        this.cipherSuites.add(cipherSuite);
    }

    public List<CompressionMethod> getCompressionMethods() {
        return Collections.unmodifiableList(this.compressionMethods);
    }

    public void setCompressionMethods(List<CompressionMethod> compressionMethods) {
        this.compressionMethods.addAll(compressionMethods);
    }

    public void addCompressionMethod(CompressionMethod compressionMethod) {
        if (this.compressionMethods == null) {
            this.compressionMethods = new ArrayList<CompressionMethod>();
        }
        this.compressionMethods.add(compressionMethod);
    }

    public SupportedEllipticCurvesExtension getSupportedEllipticCurvesExtension() {
        if (this.extensions != null) {
            List<HelloExtension> exts = this.extensions.getExtensions();
            for (HelloExtension helloExtension : exts) {
                if (!(helloExtension instanceof SupportedEllipticCurvesExtension)) continue;
                return (SupportedEllipticCurvesExtension)helloExtension;
            }
        }
        return null;
    }

    public ClientCertificateTypeExtension getClientCertificateTypeExtension() {
        if (this.extensions != null) {
            List<HelloExtension> exts = this.extensions.getExtensions();
            for (HelloExtension helloExtension : exts) {
                if (!(helloExtension instanceof ClientCertificateTypeExtension)) continue;
                return (ClientCertificateTypeExtension)helloExtension;
            }
        }
        return null;
    }

    public ServerCertificateTypeExtension getServerCertificateTypeExtension() {
        if (this.extensions != null) {
            List<HelloExtension> exts = this.extensions.getExtensions();
            for (HelloExtension helloExtension : exts) {
                if (!(helloExtension instanceof ServerCertificateTypeExtension)) continue;
                return (ServerCertificateTypeExtension)helloExtension;
            }
        }
        return null;
    }
}

