/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.ContentType;
import org.eclipse.californium.scandium.dtls.DTLSMessage;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.util.DatagramReader;
import org.eclipse.californium.scandium.util.DatagramWriter;

public class ChangeCipherSpecMessage
implements DTLSMessage {
    private static final int CCS_BITS = 8;
    private CCSType CCSProtocolType = CCSType.CHANGE_CIPHER_SPEC;

    @Override
    public ContentType getContentType() {
        return ContentType.CHANGE_CIPHER_SPEC;
    }

    public CCSType getCCSProtocolType() {
        return this.CCSProtocolType;
    }

    public String toString() {
        return "\tChange Cipher Spec Message\n";
    }

    @Override
    public byte[] toByteArray() {
        DatagramWriter writer = new DatagramWriter();
        writer.write(this.CCSProtocolType.getCode(), 8);
        return writer.toByteArray();
    }

    public static DTLSMessage fromByteArray(byte[] byteArray) throws HandshakeException {
        DatagramReader reader = new DatagramReader(byteArray);
        int code = reader.read(8);
        if (code == CCSType.CHANGE_CIPHER_SPEC.getCode()) {
            return new ChangeCipherSpecMessage();
        }
        String message = "Unknown Change Cipher Spec code received: " + code;
        AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE);
        throw new HandshakeException(message, alert);
    }

    public static enum CCSType {
        CHANGE_CIPHER_SPEC(1);

        private int code;

        private CCSType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

