/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import org.eclipse.californium.scandium.dtls.ContentType;
import org.eclipse.californium.scandium.dtls.DTLSMessage;
import org.eclipse.californium.scandium.util.ByteArrayUtils;

public class ApplicationMessage
implements DTLSMessage {
    private byte[] data;

    public ApplicationMessage(byte[] data) {
        this.data = data;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_DATA;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\tApplication Data: ").append(ByteArrayUtils.toHexString(this.data)).append("\n");
        return sb.toString();
    }

    @Override
    public byte[] toByteArray() {
        return this.data;
    }

    public static DTLSMessage fromByteArray(byte[] byteArray) {
        return new ApplicationMessage(byteArray);
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }
}

