/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.config;

import java.net.InetSocketAddress;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.Arrays;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.pskstore.PskStore;

public class DtlsConnectorConfig {
    private InetSocketAddress address;
    private Certificate[] trustStore = new Certificate[0];
    private int maxFragmentLength = 4096;
    private int maxPayloadSize = this.maxFragmentLength + 25;
    private int retransmissionTimeout = 1000;
    private int maxRetransmissions = 4;
    private boolean clientAuthenticationRequired = true;
    private boolean sendRawKey = true;
    private PskStore pskStore = null;
    private PrivateKey privateKey = null;
    private PublicKey publicKey = null;
    private Certificate[] certChain;
    private CipherSuite[] supportedCipherSuites;
    private int outboundMessageBufferSize = 100000;

    private DtlsConnectorConfig() {
    }

    public int getMaxFragmentLength() {
        return this.maxFragmentLength;
    }

    public int getMaxPayloadSize() {
        return this.maxPayloadSize;
    }

    public int getRetransmissionTimeout() {
        return this.retransmissionTimeout;
    }

    public int getMaxRetransmissions() {
        return this.maxRetransmissions;
    }

    public int getOutboundMessageBufferSize() {
        return this.outboundMessageBufferSize;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public final Certificate[] getCertificateChain() {
        if (this.certChain == null) {
            return null;
        }
        return Arrays.copyOf(this.certChain, this.certChain.length);
    }

    public final CipherSuite[] getSupportedCipherSuites() {
        if (this.supportedCipherSuites == null) {
            return null;
        }
        return Arrays.copyOf(this.supportedCipherSuites, this.supportedCipherSuites.length);
    }

    public final PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public final PskStore getPskStore() {
        return this.pskStore;
    }

    public final PublicKey getPublicKey() {
        return this.publicKey;
    }

    public final Certificate[] getTrustStore() {
        return this.trustStore;
    }

    public final boolean isClientAuthenticationRequired() {
        return this.clientAuthenticationRequired;
    }

    public final boolean isSendRawKey() {
        return this.sendRawKey;
    }

    static /* synthetic */ CipherSuite[] access$702(DtlsConnectorConfig x0, CipherSuite[] x1) {
        x0.supportedCipherSuites = x1;
        return x1;
    }

    static /* synthetic */ Certificate[] access$1202(DtlsConnectorConfig x0, Certificate[] x1) {
        x0.certChain = x1;
        return x1;
    }

    static /* synthetic */ Certificate[] access$1402(DtlsConnectorConfig x0, Certificate[] x1) {
        x0.trustStore = x1;
        return x1;
    }

    public static final class Builder {
        private DtlsConnectorConfig config = new DtlsConnectorConfig();
        private boolean clientOnly;

        public Builder(InetSocketAddress address) {
            this.config.address = address;
        }

        public Builder setClientOnly() {
            this.clientOnly = true;
            return this;
        }

        public Builder setMaxFragmentLength(int length) {
            if (length < 0) {
                throw new IllegalArgumentException("Maximum fragment length must not be negative");
            }
            this.config.maxFragmentLength = length;
            return this;
        }

        public Builder setMaxPayloadSize(int size) {
            if (size < 0) {
                throw new IllegalArgumentException("Maximum payload size must not be negative");
            }
            this.config.maxPayloadSize = size;
            return this;
        }

        public Builder setOutboundMessageBufferSize(int capacity) {
            if (capacity < 1) {
                throw new IllegalArgumentException("Outbound message buffer size must be at least 1");
            }
            this.config.outboundMessageBufferSize = capacity;
            return this;
        }

        public Builder setMaxRetransmissions(int count) {
            if (count < 1) {
                throw new IllegalArgumentException("Maximum number of retransmissions must be greater than zero");
            }
            this.config.maxRetransmissions = count;
            return this;
        }

        public Builder setClientAuthenticationRequired(boolean authRequired) {
            this.config.clientAuthenticationRequired = authRequired;
            return this;
        }

        public Builder setSupportedCipherSuites(CipherSuite[] cipherSuites) {
            if (cipherSuites == null || cipherSuites.length == 0) {
                throw new IllegalArgumentException("Connector must support at least one cipher suite");
            }
            for (CipherSuite suite : cipherSuites) {
                if (!CipherSuite.TLS_NULL_WITH_NULL_NULL.equals((Object)suite)) continue;
                throw new IllegalArgumentException("NULL Cipher Suite is not supported by connector");
            }
            DtlsConnectorConfig.access$702(this.config, Arrays.copyOf(cipherSuites, cipherSuites.length));
            return this;
        }

        public Builder setSupportedCipherSuites(String[] cipherSuites) {
            CipherSuite[] suites = new CipherSuite[cipherSuites.length];
            for (int i = 0; i < cipherSuites.length; ++i) {
                if (CipherSuite.TLS_NULL_WITH_NULL_NULL.name().equals(cipherSuites[i])) {
                    throw new IllegalArgumentException("NULL Cipher Suite is not supported by connector");
                }
                CipherSuite knownSuite = CipherSuite.getTypeByName(cipherSuites[i]);
                if (knownSuite == null) {
                    throw new IllegalArgumentException(String.format("Cipher suite [%s] is not (yet) supported", cipherSuites[i]));
                }
                suites[i] = knownSuite;
            }
            DtlsConnectorConfig.access$702(this.config, suites);
            return this;
        }

        public Builder setRetransmissionTimeout(int timeout) {
            if (timeout < 0) {
                throw new IllegalArgumentException("Retransmission timeout must not be negative");
            }
            this.config.retransmissionTimeout = timeout;
            return this;
        }

        public Builder setPskStore(PskStore pskStore) {
            this.config.pskStore = pskStore;
            return this;
        }

        public Builder setIdentity(PrivateKey privateKey, PublicKey publicKey) {
            if (privateKey == null) {
                throw new NullPointerException("The private key must not be null");
            }
            if (publicKey == null) {
                throw new NullPointerException("The public key must not be null");
            }
            this.config.privateKey = privateKey;
            this.config.publicKey = publicKey;
            DtlsConnectorConfig.access$1202(this.config, null);
            this.config.sendRawKey = true;
            return this;
        }

        public Builder setIdentity(PrivateKey privateKey, Certificate[] certificateChain, boolean preferRawPublicKeys) {
            if (privateKey == null) {
                throw new NullPointerException("The private key must not be null");
            }
            if (certificateChain == null || certificateChain.length < 1) {
                throw new NullPointerException("The certificate chain must not be null or empty");
            }
            this.config.privateKey = privateKey;
            DtlsConnectorConfig.access$1202(this.config, certificateChain);
            this.config.publicKey = certificateChain[0].getPublicKey();
            this.config.sendRawKey = preferRawPublicKeys;
            return this;
        }

        public Builder setTrustStore(Certificate[] trustedCerts) {
            if (trustedCerts == null) {
                throw new NullPointerException("Trust store must not be null");
            }
            DtlsConnectorConfig.access$1402(this.config, trustedCerts);
            return this;
        }

        public DtlsConnectorConfig build() {
            if (this.config.supportedCipherSuites == null) {
                if (this.config.pskStore != null && this.config.privateKey == null && this.config.publicKey == null) {
                    DtlsConnectorConfig.access$702(this.config, new CipherSuite[]{CipherSuite.TLS_PSK_WITH_AES_128_CCM_8, CipherSuite.TLS_PSK_WITH_AES_128_CBC_SHA256});
                } else if (this.config.pskStore == null && this.config.privateKey != null && this.config.publicKey != null) {
                    DtlsConnectorConfig.access$702(this.config, new CipherSuite[]{CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256});
                } else if (this.config.pskStore != null && this.config.privateKey != null && this.config.publicKey != null) {
                    DtlsConnectorConfig.access$702(this.config, new CipherSuite[]{CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256, CipherSuite.TLS_PSK_WITH_AES_128_CCM_8, CipherSuite.TLS_PSK_WITH_AES_128_CBC_SHA256});
                } else {
                    throw new IllegalStateException("Supported cipher suites must be set either explicitly or implicitly by means of setting the identity or PSK store");
                }
            }
            block4: for (CipherSuite suite : this.config.supportedCipherSuites) {
                switch (suite) {
                    case TLS_PSK_WITH_AES_128_CCM_8: 
                    case TLS_PSK_WITH_AES_128_CBC_SHA256: {
                        if (this.config.pskStore != null) continue block4;
                        throw new IllegalStateException("PSK store must be set when support for " + CipherSuite.TLS_PSK_WITH_AES_128_CCM_8.name() + " is configured");
                    }
                    case TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8: 
                    case TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256: {
                        if (this.clientOnly) continue block4;
                        if (this.config.getPrivateKey() == null || this.config.getPublicKey() == null) {
                            throw new IllegalStateException("Identity must be set");
                        }
                        if (this.config.privateKey.getAlgorithm().equals("EC") && this.config.getPublicKey().getAlgorithm().equals("EC")) continue block4;
                        throw new IllegalStateException("Keys must be ECDSA capable when support for an ECDHE_ECDSA based cipher suite is configured");
                    }
                }
            }
            return this.config;
        }
    }
}

