/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.examples;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.logging.Level;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.RawData;
import org.eclipse.californium.elements.RawDataChannel;
import org.eclipse.californium.scandium.DTLSConnector;
import org.eclipse.californium.scandium.ScandiumLogger;
import org.eclipse.californium.scandium.dtls.pskstore.InMemoryPskStore;

public class ExampleDTLSServer {
    private static final int DEFAULT_PORT = 5684;
    private static final String TRUST_STORE_PASSWORD = "rootPass";
    private static final String KEY_STORE_PASSWORD = "endPass";
    private static final String KEY_STORE_LOCATION = "certs/keyStore.jks";
    private static final String TRUST_STORE_LOCATION = "certs/trustStore.jks";
    private DTLSConnector dtlsConnector;

    public ExampleDTLSServer() {
        InMemoryPskStore pskStore = new InMemoryPskStore();
        pskStore.setKey("Client_identity", "secretPSK".getBytes());
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            FileInputStream in = new FileInputStream(KEY_STORE_LOCATION);
            keyStore.load(in, KEY_STORE_PASSWORD.toCharArray());
            KeyStore trustStore = KeyStore.getInstance("JKS");
            FileInputStream inTrust = new FileInputStream(TRUST_STORE_LOCATION);
            trustStore.load(inTrust, TRUST_STORE_PASSWORD.toCharArray());
            Certificate[] trustedCertificates = new Certificate[]{trustStore.getCertificate("root")};
            this.dtlsConnector = new DTLSConnector(new InetSocketAddress(5684), trustedCertificates);
            this.dtlsConnector.getConfig().setPrivateKey((PrivateKey)keyStore.getKey("server", KEY_STORE_PASSWORD.toCharArray()), keyStore.getCertificateChain("server"), true);
            this.dtlsConnector.getConfig().setPskStore(pskStore);
            this.dtlsConnector.setRawDataReceiver(new RawDataChannelImpl((Connector)this.dtlsConnector));
        }
        catch (IOException | GeneralSecurityException e) {
            System.err.println("Could not load the keystore");
            e.printStackTrace();
        }
    }

    public void start() {
        try {
            this.dtlsConnector.start();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected error starting the DTLS UDP server", e);
        }
    }

    public static void main(String[] args) {
        ExampleDTLSServer server = new ExampleDTLSServer();
        server.start();
        try {
            System.in.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        ScandiumLogger.initialize();
        ScandiumLogger.setLevel(Level.ALL);
    }

    private class RawDataChannelImpl
    implements RawDataChannel {
        private Connector connector;

        public RawDataChannelImpl(Connector con) {
            this.connector = con;
        }

        public void receiveData(RawData raw) {
            if (raw.getAddress() == null) {
                throw new NullPointerException();
            }
            if (raw.getPort() == 0) {
                throw new NullPointerException();
            }
            System.out.println(new String(raw.getBytes()));
            this.connector.send(new RawData("ACK".getBytes(), raw.getAddress(), raw.getPort()));
        }
    }
}

