/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.californium.scandium.dtls.HelloExtension;
import org.eclipse.californium.scandium.dtls.cipher.ECDHECryptography;
import org.eclipse.californium.scandium.util.DatagramReader;
import org.eclipse.californium.scandium.util.DatagramWriter;

public class SupportedEllipticCurvesExtension
extends HelloExtension {
    private static final int LIST_LENGTH_BITS = 16;
    private static final int CURVE_BITS = 16;
    private List<Integer> ellipticCurveList;

    public SupportedEllipticCurvesExtension(List<Integer> ellipticCurveList) {
        super(HelloExtension.ExtensionType.ELLIPTIC_CURVES);
        this.ellipticCurveList = ellipticCurveList;
    }

    @Override
    public byte[] toByteArray() {
        DatagramWriter writer = new DatagramWriter();
        writer.writeBytes(super.toByteArray());
        int listLength = this.ellipticCurveList.size() * 2;
        writer.write(listLength + 2, 16);
        writer.write(listLength, 16);
        for (Integer curveId : this.ellipticCurveList) {
            writer.write(curveId, 16);
        }
        return writer.toByteArray();
    }

    public static HelloExtension fromByteArray(byte[] byteArray) {
        DatagramReader reader = new DatagramReader(byteArray);
        ArrayList<Integer> ellipticCurveList = new ArrayList<Integer>();
        for (int listLength = reader.read(16); listLength > 0; listLength -= 2) {
            int id = reader.read(16);
            ellipticCurveList.add(id);
        }
        return new SupportedEllipticCurvesExtension(ellipticCurveList);
    }

    @Override
    public int getLength() {
        return 6 + this.ellipticCurveList.size() * 2;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\t\t\t\tLength: " + (this.getLength() - 4) + "\n");
        sb.append("\t\t\t\tElliptic Curves Length: " + (this.getLength() - 6) + "\n");
        sb.append("\t\t\t\tElliptic Curves (" + this.ellipticCurveList.size() + " curves):\n");
        for (Integer curveId : this.ellipticCurveList) {
            String curveName = ECDHECryptography.NAMED_CURVE_TABLE[curveId];
            sb.append("\t\t\t\t\tElliptic Curve: " + curveName + " (" + curveId + ")\n");
        }
        return sb.toString();
    }

    public List<Integer> getEllipticCurveList() {
        return this.ellipticCurveList;
    }
}

