/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import org.eclipse.californium.scandium.dtls.CertificateRequest;

public class SignatureAndHashAlgorithm {
    private CertificateRequest.HashAlgorithm hash;
    private CertificateRequest.SignatureAlgorithm signature;

    public SignatureAndHashAlgorithm(CertificateRequest.HashAlgorithm hashAlgorithm, CertificateRequest.SignatureAlgorithm signatureAlgorithm) {
        this.signature = signatureAlgorithm;
        this.hash = hashAlgorithm;
    }

    public SignatureAndHashAlgorithm(int hashAlgorithmCode, int signatureAlgorithmCode) {
        this.signature = CertificateRequest.SignatureAlgorithm.getAlgorithmByCode(signatureAlgorithmCode);
        this.hash = CertificateRequest.HashAlgorithm.getAlgorithmByCode(hashAlgorithmCode);
    }

    public CertificateRequest.SignatureAlgorithm getSignature() {
        return this.signature;
    }

    public void setSignature(CertificateRequest.SignatureAlgorithm signature) {
        this.signature = signature;
    }

    public CertificateRequest.HashAlgorithm getHash() {
        return this.hash;
    }

    public void setHash(CertificateRequest.HashAlgorithm hash) {
        this.hash = hash;
    }

    public String toString() {
        return this.hash.toString() + "with" + this.signature.toString();
    }
}

