/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HelloExtension;
import org.eclipse.californium.scandium.util.DatagramReader;
import org.eclipse.californium.scandium.util.DatagramWriter;

public class HelloExtensions {
    private static final Logger LOGGER = Logger.getLogger(HelloExtensions.class.getCanonicalName());
    public static final int LENGTH_BITS = 16;
    private List<HelloExtension> extensions;

    public HelloExtensions() {
        this.extensions = new ArrayList<HelloExtension>();
    }

    public HelloExtensions(List<HelloExtension> extensions) {
        this.extensions = extensions;
    }

    public int getLength() {
        int length = 0;
        for (HelloExtension extension : this.extensions) {
            length += extension.getLength();
        }
        return length;
    }

    public void addExtension(HelloExtension extension) {
        this.extensions.add(extension);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\t\tExtensions Length: " + this.getLength() + "\n");
        for (HelloExtension ext : this.extensions) {
            sb.append(ext.toString());
        }
        return sb.toString();
    }

    public byte[] toByteArray() {
        DatagramWriter writer = new DatagramWriter();
        writer.write(this.getLength(), 16);
        for (HelloExtension extension : this.extensions) {
            writer.writeBytes(extension.toByteArray());
        }
        return writer.toByteArray();
    }

    public static HelloExtensions fromByteArray(byte[] byteArray) throws HandshakeException {
        int length;
        int extensionLength;
        DatagramReader reader = new DatagramReader(byteArray);
        ArrayList<HelloExtension> extensions = new ArrayList<HelloExtension>();
        for (length = reader.read(16); length > 0; length -= 4 + extensionLength) {
            byte[] extensionBytes;
            int typeId = reader.read(16);
            HelloExtension extension = HelloExtension.fromByteArray(typeId, extensionBytes = reader.readBytes(extensionLength = reader.read(16)));
            if (extension != null) {
                extensions.add(extension);
                continue;
            }
            LOGGER.log(Level.FINER, String.format("Client included an unknown extension type code in its Hello message [%d]", typeId));
        }
        if (length < 0) {
            throw new HandshakeException("Hello message contained malformed extensions", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.DECODE_ERROR));
        }
        return new HelloExtensions(extensions);
    }

    public List<HelloExtension> getExtensions() {
        return this.extensions;
    }
}

