/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.io.IOException;
import java.net.BindException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import org.eclipse.californium.elements.UDPConnector;
import org.eclipse.californium.elements.util.NetworkInterfacesUtil;
import org.eclipse.californium.elements.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpMulticastConnector
extends UDPConnector {
    public static final Logger LOGGER = LoggerFactory.getLogger(UdpMulticastConnector.class);
    private InetAddress intfAddress;
    private InetAddress[] multicastGroups;
    private boolean loopbackDisable;

    public UdpMulticastConnector(InetAddress intfAddress, InetSocketAddress localAddress, InetAddress ... multicastGroups) {
        super(localAddress);
        boolean noGroups;
        this.setReuseAddress(true);
        this.intfAddress = intfAddress;
        this.multicastGroups = multicastGroups;
        boolean bl = noGroups = multicastGroups == null || multicastGroups.length == 0;
        if (NetworkInterfacesUtil.isBroadcastAddress(localAddress.getAddress())) {
            this.multicast = noGroups;
        } else {
            if (noGroups && localAddress.getAddress().isMulticastAddress()) {
                this.multicastGroups = new InetAddress[]{localAddress.getAddress()};
                noGroups = false;
            }
            if (noGroups) {
                if (localAddress.getAddress().isMulticastAddress()) {
                    this.multicastGroups = new InetAddress[]{localAddress.getAddress()};
                } else {
                    throw new IllegalArgumentException("missing multicast address to join!");
                }
            }
            boolean bl2 = this.multicast = this.multicastGroups.length == 1;
            if (this.multicast) {
                this.effectiveAddr = new InetSocketAddress(this.multicastGroups[0], localAddress != null ? localAddress.getPort() : 0);
            }
        }
    }

    public UdpMulticastConnector(InetSocketAddress localAddress, InetAddress ... multicastGroups) {
        this(null, localAddress, multicastGroups);
    }

    public void setLoopbackMode(boolean disable) {
        this.loopbackDisable = disable;
    }

    @Override
    public synchronized void start() throws IOException {
        if (this.running) {
            return;
        }
        InetAddress effectiveInterface = this.localAddr.getAddress();
        MulticastSocket socket = new MulticastSocket(null);
        socket.setLoopbackMode(this.loopbackDisable);
        try {
            socket.bind(this.localAddr);
            LOGGER.info("socket {}, loopback mode {}", (Object)StringUtil.toString((InetSocketAddress)socket.getLocalSocketAddress()), (Object)socket.getLoopbackMode());
        }
        catch (BindException ex) {
            socket.close();
            LOGGER.error("can't bind to {}", (Object)StringUtil.toString(this.localAddr));
            throw ex;
        }
        catch (SocketException ex) {
            socket.close();
            LOGGER.error("can't bind to {}", (Object)StringUtil.toString(this.localAddr));
            throw ex;
        }
        if (this.intfAddress != null && !this.intfAddress.isAnyLocalAddress()) {
            try {
                socket.setInterface(this.intfAddress);
                effectiveInterface = this.intfAddress;
                LOGGER.info("interface {}", (Object)StringUtil.toString(this.intfAddress));
            }
            catch (SocketException ex) {
                LOGGER.error("error: multicast set interface", (Throwable)ex);
            }
        }
        if (this.multicastGroups != null) {
            for (InetAddress group : this.multicastGroups) {
                try {
                    socket.joinGroup(group);
                    LOGGER.info("joined group {}", (Object)StringUtil.toString(group));
                }
                catch (SocketException ex) {
                    socket.close();
                    if (group instanceof Inet4Address) {
                        if (effectiveInterface.isAnyLocalAddress() && !NetworkInterfacesUtil.isAnyIpv4() || effectiveInterface instanceof Inet6Address) {
                            throw new SocketException("IPv6 only interface doesn't support IPv4 multicast!");
                        }
                    } else if (group instanceof Inet6Address && (effectiveInterface.isAnyLocalAddress() && !NetworkInterfacesUtil.isAnyIpv6() || effectiveInterface instanceof Inet4Address)) {
                        throw new SocketException("IPv4 only interface doesn't support IPv6 multicast!");
                    }
                    throw ex;
                }
            }
        }
        this.init(socket);
        if (this.multicast && this.multicastGroups != null && this.multicastGroups.length == 1) {
            this.effectiveAddr = new InetSocketAddress(this.multicastGroups[0], socket.getLocalPort());
        }
    }
}

