/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.PublicKey;
import java.security.cert.CertPath;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeResult;

public final class CertificateVerificationResult
extends HandshakeResult {
    private final CertPath certificatePath;
    private final PublicKey publicKey;
    private final HandshakeException exception;

    public CertificateVerificationResult(ConnectionId cid, CertPath certificatePath, Object customArgument) {
        super(cid, customArgument);
        this.certificatePath = certificatePath;
        this.publicKey = null;
        this.exception = null;
    }

    public CertificateVerificationResult(ConnectionId cid, PublicKey publicKey, Object customArgument) {
        super(cid, customArgument);
        this.certificatePath = null;
        this.publicKey = publicKey;
        this.exception = null;
    }

    public CertificateVerificationResult(ConnectionId cid, HandshakeException exception) {
        super(cid, null);
        if (exception == null) {
            throw new NullPointerException("exception must not be null!");
        }
        this.certificatePath = null;
        this.publicKey = null;
        this.exception = exception;
    }

    public CertPath getCertificatePath() {
        return this.certificatePath;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public HandshakeException getException() {
        return this.exception;
    }
}

