/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.examples;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.californium.core.CoapExchange;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.server.resources.MyIpResource;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.config.TcpConfig;
import org.eclipse.californium.elements.config.UdpConfig;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.plugtests.AbstractTestServer;
import org.eclipse.californium.plugtests.PlugtestServer;
import org.eclipse.californium.plugtests.resources.MyContext;
import org.eclipse.californium.scandium.config.DtlsConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class SimpleFileServer
extends AbstractTestServer {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleFileServer.class);
    private static final File CONFIG_FILE = new File("Californium3.properties");
    private static final String CONFIG_HEADER = "Californium CoAP Properties file for Fileserver";
    private static final int DEFAULT_MAX_RESOURCE_SIZE = 0x200000;
    private static final int DEFAULT_BLOCK_SIZE = 512;
    private static Configuration.DefinitionsProvider DEFAULTS;
    private static final String DEFAULT_PATH = "data";
    private static final Config config;

    public static void main(String[] args) {
        String version = StringUtil.CALIFORNIUM_VERSION == null ? "" : StringUtil.CALIFORNIUM_VERSION;
        CommandLine cmd = new CommandLine(config);
        try {
            CommandLine.ParseResult result = cmd.parseArgs(args);
            if (result.isVersionHelpRequested()) {
                System.out.println("\nCalifornium (Cf) " + cmd.getCommandName() + " " + version);
                cmd.printVersionHelp(System.out);
                System.out.println();
            }
            if (result.isUsageHelpRequested()) {
                cmd.usage(System.out);
                return;
            }
        }
        catch (CommandLine.ParameterException ex) {
            System.err.println(ex.getMessage());
            System.err.println();
            cmd.usage(System.err);
            System.exit(-1);
        }
        Configuration netConfig = Configuration.createWithFile(CONFIG_FILE, CONFIG_HEADER, DEFAULTS);
        Configuration udpConfig = new Configuration(netConfig).set(CoapConfig.MAX_MESSAGE_SIZE, netConfig.get(EXTERNAL_UDP_MAX_MESSAGE_SIZE)).set(CoapConfig.PREFERRED_BLOCK_SIZE, netConfig.get(EXTERNAL_UDP_PREFERRED_BLOCK_SIZE));
        HashMap<AbstractTestServer.Select, Configuration> protocolConfig = new HashMap<AbstractTestServer.Select, Configuration>();
        protocolConfig.put(new AbstractTestServer.Select(AbstractTestServer.Protocol.UDP, AbstractTestServer.InterfaceType.EXTERNAL), udpConfig);
        try {
            String filesRootPath = SimpleFileServer.config.fileRoot;
            String coapRootPath = SimpleFileServer.config.pathRoot;
            if (0 <= coapRootPath.indexOf(47)) {
                LOG.error("{} don't use '/'! Only one path segement for coap root allowed!", (Object)coapRootPath);
                return;
            }
            File filesRoot = new File(filesRootPath);
            if (!filesRoot.exists()) {
                LOG.error("{} doesn't exists!", (Object)filesRoot.getAbsolutePath());
                return;
            }
            if (!filesRoot.isDirectory()) {
                LOG.error("{} is no directory!", (Object)filesRoot.getAbsolutePath());
                return;
            }
            SimpleFileServer.listURIs(filesRoot, coapRootPath);
            SimpleFileServer server = new SimpleFileServer(netConfig, protocolConfig, coapRootPath, filesRoot);
            server.add(new MyContext("mycontext", version, true));
            server.addEndpoints(config);
            server.start();
        }
        catch (SocketException e) {
            LOG.error("Failed to initialize server: ", e);
        }
    }

    public static void listURIs(File filesRoot, String coapRootPath) {
        File[] files;
        for (File file : files = filesRoot.listFiles()) {
            if (!file.isFile() || !file.canRead()) continue;
            LOG.info("GET: coap://<host>/{}/{}", (Object)coapRootPath, (Object)file.getName());
        }
        for (File file : files) {
            if (!file.isDirectory() || !file.canRead()) continue;
            SimpleFileServer.listURIs(file, coapRootPath + "/" + file.getName());
        }
    }

    public SimpleFileServer(Configuration config, Map<AbstractTestServer.Select, Configuration> protocolConfig, String coapRootPath, File filesRoot) throws SocketException {
        super(config, protocolConfig);
        this.add(new FileResource(config, coapRootPath, filesRoot));
        this.add(new MyIpResource("myip", true));
    }

    static {
        CoapConfig.register();
        UdpConfig.register();
        DtlsConfig.register();
        TcpConfig.register();
        DEFAULTS = config -> {
            config.set(CoapConfig.MAX_RESOURCE_BODY_SIZE, 0x200000);
            config.set(CoapConfig.MAX_MESSAGE_SIZE, 512);
            config.set(CoapConfig.PREFERRED_BLOCK_SIZE, 512);
            config.setTransient(DtlsConfig.DTLS_CLIENT_AUTHENTICATION_MODE);
            config.setTransient(TcpConfig.TLS_CLIENT_AUTHENTICATION_MODE);
            config.set(EXTERNAL_UDP_MAX_MESSAGE_SIZE, 64);
            config.set(EXTERNAL_UDP_PREFERRED_BLOCK_SIZE, 64);
        };
        SimpleFileServer.config = new Config();
    }

    @CommandLine.Command(name="SimpleFileServer", version={"(c) 2017, Bosch Software Innovations GmbH and others."})
    public static class Config
    extends PlugtestServer.BaseConfig {
        @CommandLine.Option(names={"--file-root"}, description={"files root. Default \"data\""})
        public String fileRoot = "data";
        @CommandLine.Option(names={"--path-root"}, description={"resource-path root. Default \"data\""})
        public String pathRoot = "data";
    }

    class FileResource
    extends CoapResource {
        private final Configuration config;
        private final File filesRoot;

        public FileResource(Configuration config, String coapRootPath, File filesRoot) {
            super(coapRootPath);
            this.addSupportedContentFormats(42);
            this.config = config;
            this.filesRoot = filesRoot;
        }

        @Override
        public Resource getChild(String name) {
            return this;
        }

        @Override
        public void handleRequest(Exchange exchange) {
            try {
                super.handleRequest(exchange);
            }
            catch (Exception e) {
                LOG.error("Exception while handling a request on the {} resource", (Object)this.getName(), (Object)e);
                exchange.sendResponse(new Response(CoAP.ResponseCode.INTERNAL_SERVER_ERROR));
            }
        }

        @Override
        public void handleGET(CoapExchange exchange) {
            Request request = exchange.advanced().getRequest();
            LOG.info("Get received : {}", (Object)request);
            String myURI = this.getURI() + "/";
            String path = "/" + request.getOptions().getUriPathString();
            if (!path.startsWith(myURI)) {
                LOG.info("Request {} does not match {}!", (Object)path, (Object)myURI);
                exchange.respond(CoAP.ResponseCode.INTERNAL_SERVER_ERROR);
                return;
            }
            path = path.substring(myURI.length());
            if (request.getOptions().hasBlock2()) {
                LOG.info("Send file {} {}", (Object)path, (Object)request.getOptions().getBlock2());
            } else {
                LOG.info("Send file {}", (Object)path);
            }
            File file = new File(this.filesRoot, path);
            if (!file.exists() || !file.isFile()) {
                LOG.warn("File {} doesn't exist!", (Object)file.getAbsolutePath());
                exchange.respond(CoAP.ResponseCode.NOT_FOUND);
                return;
            }
            if (!this.checkFileLocation(file, this.filesRoot)) {
                LOG.warn("File {} is not in {}!", (Object)file.getAbsolutePath(), (Object)this.filesRoot.getAbsolutePath());
                exchange.respond(CoAP.ResponseCode.UNAUTHORIZED);
                return;
            }
            if (!file.canRead()) {
                LOG.warn("File {} is not readable!", (Object)file.getAbsolutePath());
                exchange.respond(CoAP.ResponseCode.UNAUTHORIZED);
                return;
            }
            long maxLength = this.config.get(CoapConfig.MAX_RESOURCE_BODY_SIZE).intValue();
            long length = file.length();
            if (length > maxLength) {
                LOG.warn("File {} is too large {} (max.: {})!", file.getAbsolutePath(), length, maxLength);
                exchange.respond(CoAP.ResponseCode.INTERNAL_SERVER_ERROR);
                return;
            }
            try (FileInputStream in = new FileInputStream(file);){
                byte[] content = new byte[(int)length];
                int r = ((InputStream)in).read(content);
                if (length == (long)r) {
                    Response response = new Response(CoAP.ResponseCode.CONTENT);
                    response.setPayload(content);
                    response.getOptions().setSize2((int)length);
                    response.getOptions().setContentFormat(42);
                    exchange.respond(response);
                } else {
                    LOG.warn("File {} could not be read in!", (Object)file.getAbsolutePath());
                    exchange.respond(CoAP.ResponseCode.INTERNAL_SERVER_ERROR);
                }
            }
            catch (IOException ex) {
                LOG.warn("File {}:", (Object)file.getAbsolutePath(), (Object)ex);
                exchange.respond(CoAP.ResponseCode.INTERNAL_SERVER_ERROR);
            }
        }

        private boolean checkFileLocation(File file, File root) {
            try {
                return file.getCanonicalPath().startsWith(root.getCanonicalPath());
            }
            catch (IOException ex) {
                LOG.warn("File {}:", (Object)file.getAbsolutePath(), (Object)ex);
                return false;
            }
        }
    }
}

