/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.server.resources;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class ResourceAttributes {
    private final ConcurrentMap<String, AttributeValues> attributes = new ConcurrentHashMap<String, AttributeValues>();

    public ResourceAttributes() {
    }

    public ResourceAttributes(ResourceAttributes attributes) {
        this.copy(attributes);
    }

    public int getCount() {
        return this.attributes.size();
    }

    public String getTitle() {
        return this.getFirstAttributeValue("title");
    }

    public void setTitle(String title) {
        this.findAttributeValues("title").setOnly(title);
    }

    public void clearTitle() {
        this.attributes.remove("title");
    }

    public void addResourceType(String type) {
        this.findAttributeValues("rt").add(type);
    }

    public List<String> getResourceTypes() {
        return this.getAttributeValues("rt");
    }

    public void clearResourceType() {
        this.attributes.remove("rt");
    }

    public void addInterfaceDescription(String description) {
        this.findAttributeValues("if").add(description);
    }

    public List<String> getInterfaceDescriptions() {
        return this.getAttributeValues("if");
    }

    public void clearInterfaceDescriptions() {
        this.attributes.remove("if");
    }

    public void setMaximumSizeEstimate(String size) {
        this.findAttributeValues("sz").setOnly(size);
    }

    public void setMaximumSizeEstimate(int size) {
        this.findAttributeValues("sz").setOnly(Integer.toString(size));
    }

    public String getMaximumSizeEstimate() {
        return this.getFirstAttributeValue("sz");
    }

    public void addContentType(int type) {
        this.findAttributeValues("ct").add(Integer.toString(type));
    }

    public void addContentTypes(int ... types) {
        AttributeValues attributeValues = this.findAttributeValues("ct");
        for (int type : types) {
            attributeValues.add(Integer.toString(type));
        }
    }

    public List<String> getContentTypes() {
        return this.getAttributeValues("ct");
    }

    public void clearContentType() {
        this.attributes.remove("ct");
    }

    public void setObservable() {
        this.findAttributeValues("obs").setOnly("");
    }

    public boolean hasObservable() {
        return this.hasAttribute("obs");
    }

    public void clearObservable() {
        this.attributes.remove("obs");
    }

    public void setOscoreOnly() {
        this.findAttributeValues("osc").setOnly("");
    }

    public boolean hasOscoreOnly() {
        return this.hasAttribute("osc");
    }

    public void clearOscoreOnly() {
        this.attributes.remove("osc");
    }

    public void setAttribute(String attr, String value) {
        this.findAttributeValues(attr).setOnly(value);
    }

    public boolean hasAttribute(String attr) {
        return !this.getAttributeValues(attr).isEmpty();
    }

    public void addAttribute(String attr) {
        this.addAttribute(attr, "");
    }

    public void addAttribute(String attr, String value) {
        this.findAttributeValues(attr).add(value);
    }

    public void addAttribute(String attr, List<String> values) {
        this.findAttributeValues(attr).addAll(values);
    }

    public boolean containsAttribute(String attr) {
        return this.attributes.containsKey(attr);
    }

    public void clearAttribute(String attr) {
        this.attributes.remove(attr);
    }

    public Set<String> getAttributeKeySet() {
        return this.attributes.keySet();
    }

    public List<String> getAttributeValues(String attr) {
        AttributeValues list = (AttributeValues)this.attributes.get(attr);
        if (list != null) {
            return list.getAll();
        }
        return Collections.emptyList();
    }

    public String getFirstAttributeValue(String attr) {
        AttributeValues list = (AttributeValues)this.attributes.get(attr);
        if (list != null) {
            return list.getFirst();
        }
        return null;
    }

    public void copy(ResourceAttributes other) {
        if (this == other) {
            return;
        }
        this.attributes.clear();
        for (String attrName : other.getAttributeKeySet()) {
            AttributeValues attributeValues = (AttributeValues)other.attributes.get(attrName);
            if (attributeValues == null) continue;
            this.attributes.put(attrName, attributeValues.clone());
        }
    }

    private AttributeValues findAttributeValues(String attr) {
        AttributeValues prev;
        AttributeValues list = (AttributeValues)this.attributes.get(attr);
        if (list == null && (prev = this.attributes.putIfAbsent(attr, list = new AttributeValues())) != null) {
            return prev;
        }
        return list;
    }

    private static final class AttributeValues {
        private final List<String> list = new CopyOnWriteArrayList<String>();

        private AttributeValues() {
        }

        private List<String> getAll() {
            return Collections.unmodifiableList(this.list);
        }

        private synchronized void add(String value) {
            if (!this.list.contains(value)) {
                this.list.add(value);
            }
        }

        private synchronized void addAll(List<String> values) {
            for (String value : values) {
                this.add(value);
            }
        }

        private synchronized String getFirst() {
            if (this.list.isEmpty()) {
                return "";
            }
            return this.list.get(0);
        }

        private synchronized void setOnly(String value) {
            this.list.clear();
            if (value != null) {
                this.list.add(value);
            }
        }

        protected synchronized AttributeValues clone() {
            AttributeValues values = new AttributeValues();
            values.addAll(this.getAll());
            return values;
        }
    }
}

