/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.Principal;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.coap.UriQueryParameter;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.elements.DtlsEndpointContext;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.MapBasedEndpointContext;
import org.eclipse.californium.elements.auth.ApplicationAuthorizer;

public class CoapExchange {
    private final Exchange exchange;
    private String locationPath = null;
    private String locationQuery = null;
    private String handshakeMode = null;
    private long maxAge = 60L;
    private byte[] eTag = null;

    public CoapExchange(Exchange exchange) {
        if (exchange == null) {
            throw new NullPointerException("exchange must not be null");
        }
        this.exchange = exchange;
    }

    public final Principal getSourcePrincipal() {
        return this.getSourceContext().getPeerIdentity();
    }

    public final EndpointContext getSourceContext() {
        return this.exchange.getRequest().getSourceContext();
    }

    public final InetSocketAddress getSourceSocketAddress() {
        return this.getSourceContext().getPeerAddress();
    }

    public final InetAddress getSourceAddress() {
        return this.getSourceSocketAddress().getAddress();
    }

    public final int getSourcePort() {
        return this.getSourceSocketAddress().getPort();
    }

    public ApplicationAuthorizer getApplicationAuthorizer() {
        return this.exchange.getApplicationAuthorizer();
    }

    public boolean isMulticastRequest() {
        return this.exchange.getRequest().isMulticast();
    }

    public CoAP.Code getRequestCode() {
        return this.exchange.getRequest().getCode();
    }

    public OptionSet getRequestOptions() {
        return this.exchange.getRequest().getOptions();
    }

    public String getQueryParameter(String name) {
        UriQueryParameter uriQueryParameter = this.getRequestOptions().getUriQueryParameter();
        if (uriQueryParameter.hasParameter(name)) {
            return uriQueryParameter.getArgument(name, Boolean.TRUE.toString());
        }
        return null;
    }

    public byte[] getRequestPayload() {
        return this.exchange.getRequest().getPayload();
    }

    public int getRequestPayloadSize() {
        return this.exchange.getRequest().getPayloadSize();
    }

    public String getRequestText() {
        return this.exchange.getRequest().getPayloadString();
    }

    public void accept() {
        this.exchange.sendAccept(this.applyHandshakeMode());
    }

    public void reject() {
        this.exchange.sendReject(this.applyHandshakeMode());
    }

    public void setLocationPath(String path) {
        this.locationPath = path;
    }

    public void setLocationQuery(String query) {
        this.locationQuery = query;
    }

    public void setHandshakeMode(String handshakeMode) {
        if (!handshakeMode.equals("auto") && !handshakeMode.equals("none")) {
            throw new IllegalArgumentException("handshake mode must be either \"auto\" or \"none\"!");
        }
        this.handshakeMode = handshakeMode;
    }

    public void setMaxAge(long age) {
        this.maxAge = age;
    }

    public void setETag(byte[] tag) {
        this.eTag = tag;
    }

    public void respondClientOverload(int seconds) {
        this.setMaxAge(seconds);
        this.respond(CoAP.ResponseCode.TOO_MANY_REQUESTS);
    }

    public void respondOverload(int seconds) {
        this.setMaxAge(seconds);
        this.respond(CoAP.ResponseCode.SERVICE_UNAVAILABLE);
    }

    public void respond(CoAP.ResponseCode code) {
        this.respond(new Response(code));
    }

    public void respond(String payload) {
        this.respond(CoAP.ResponseCode.CONTENT, payload);
    }

    public void respond(CoAP.ResponseCode code, String payload) {
        Response response = new Response(code);
        response.setPayload(payload);
        response.getOptions().setContentFormat(0);
        this.respond(response);
    }

    public void respond(CoAP.ResponseCode code, byte[] payload) {
        Response response = new Response(code);
        response.setPayload(payload);
        this.respond(response);
    }

    public void respond(CoAP.ResponseCode code, byte[] payload, int contentFormat) {
        Response response = new Response(code);
        response.setPayload(payload);
        response.getOptions().setContentFormat(contentFormat);
        this.respond(response);
    }

    public void respond(CoAP.ResponseCode code, String payload, int contentFormat) {
        Response response = new Response(code);
        response.setPayload(payload);
        response.getOptions().setContentFormat(contentFormat);
        this.respond(response);
    }

    public void respond(Response response) {
        if (response == null) {
            throw new NullPointerException("Response must not be null!");
        }
        if (this.locationPath != null) {
            response.getOptions().setLocationPath(this.locationPath);
        }
        if (this.locationQuery != null) {
            response.getOptions().setLocationQuery(this.locationQuery);
        }
        if (this.maxAge != 60L) {
            response.getOptions().setMaxAge(this.maxAge);
        }
        if (this.eTag != null) {
            response.getOptions().clearETags();
            response.getOptions().addETag(this.eTag);
        }
        if (response.getDestinationContext() == null) {
            response.setDestinationContext(this.applyHandshakeMode());
        }
        this.exchange.sendResponse(response);
    }

    private EndpointContext applyHandshakeMode() {
        EndpointContext context = this.exchange.getCurrentRequest().getSourceContext();
        if (this.handshakeMode != null && context.get(DtlsEndpointContext.KEY_HANDSHAKE_MODE) == null) {
            MapBasedEndpointContext.Attributes attributes = new MapBasedEndpointContext.Attributes();
            attributes.add(DtlsEndpointContext.KEY_HANDSHAKE_MODE, this.handshakeMode);
            context = MapBasedEndpointContext.addEntries(context, attributes);
        }
        return context;
    }

    public Exchange advanced() {
        return this.exchange;
    }
}

