/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests.resources;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.server.resources.CoapExchange;

public class Validate
extends CoapResource {
    private static final byte[] EMPTY_ETAG = new byte[]{0};
    private byte[] data = null;
    private int dataCf = 0;
    private byte[] etag = EMPTY_ETAG;

    public Validate() {
        super("validate");
        this.getAttributes().setTitle("Resource which varies");
    }

    @Override
    public void handleGET(CoapExchange exchange) {
        Response response;
        Request request = exchange.advanced().getRequest();
        if (exchange.getRequestOptions().containsETag(this.etag)) {
            response = new Response(CoAP.ResponseCode.VALID);
            response.getOptions().addETag(this.etag);
            this.storeData(null, -1);
        } else {
            int cf;
            int n = cf = this.data == null ? 0 : this.dataCf;
            if (!this.checkContentFormat(exchange, cf)) {
                return;
            }
            response = new Response(CoAP.ResponseCode.CONTENT);
            if (this.data == null) {
                StringBuilder payload = new StringBuilder();
                payload.append(String.format("Type: %d (%s)\nCode: %d (%s)\nMID: %d", new Object[]{request.getType().value, request.getType(), request.getCode().value, request.getCode(), request.getMID()}));
                if (!request.hasEmptyToken()) {
                    payload.append("\nToken: ");
                    payload.append(request.getTokenString());
                }
                if (payload.length() > 64) {
                    payload.delete(63, payload.length());
                    payload.append('\u00bb');
                }
                response.setPayload(payload.toString());
            } else {
                response.setPayload(this.data);
            }
            response.getOptions().setContentFormat(cf);
            response.getOptions().addETag(this.etag);
        }
        exchange.respond(response);
    }

    @Override
    public void handlePUT(CoapExchange exchange) {
        if (exchange.getRequestOptions().isIfMatch(this.etag)) {
            if (exchange.getRequestOptions().hasContentFormat()) {
                this.storeData(exchange.getRequestPayload(), exchange.getRequestOptions().getContentFormat());
                exchange.setETag(this.etag);
                exchange.respond(CoAP.ResponseCode.CHANGED);
            } else {
                exchange.respond(CoAP.ResponseCode.BAD_REQUEST, "Content-Format not set");
            }
        } else if (exchange.getRequestOptions().hasIfNoneMatch() && this.data == null) {
            this.storeData(exchange.getRequestPayload(), exchange.getRequestOptions().getContentFormat());
            exchange.respond(CoAP.ResponseCode.CREATED);
        } else {
            exchange.respond(CoAP.ResponseCode.PRECONDITION_FAILED);
            this.storeData(null, -1);
        }
    }

    @Override
    public void handleDELETE(CoapExchange exchange) {
        this.storeData(null, -1);
        exchange.respond(CoAP.ResponseCode.DELETED);
    }

    private synchronized void storeData(byte[] payload, int cf) {
        if (payload != null) {
            this.data = payload;
            this.dataCf = cf;
            this.etag = ByteBuffer.allocate(4).putInt(Arrays.hashCode(this.data)).array();
            this.getAttributes().clearContentType();
            this.getAttributes().addContentType(this.dataCf);
            this.getAttributes().setMaximumSizeEstimate(this.data.length);
        } else {
            this.data = null;
            this.etag = EMPTY_ETAG;
        }
        this.changed();
    }
}

