/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests.resources;

import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.server.resources.CoapExchange;

public class Query
extends CoapResource {
    public Query() {
        super("query");
        this.getAttributes().setTitle("Resource accepting query parameters");
        this.addSupportedContentFormats(0);
    }

    @Override
    public void handleGET(CoapExchange exchange) {
        Request request = exchange.advanced().getRequest();
        StringBuilder payload = new StringBuilder();
        payload.append(String.format("Type: %d (%s)\nCode: %d (%s)\nMID: %d\n", new Object[]{request.getType().value, request.getType(), request.getCode().value, request.getCode(), request.getMID()}));
        payload.append("?").append(request.getOptions().getUriQueryString());
        if (payload.length() > 64) {
            payload.delete(63, payload.length());
            payload.append('\u00bb');
        }
        exchange.respond(CoAP.ResponseCode.CONTENT, payload.toString(), 0);
    }
}

