/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests.resources;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.californium.elements.util.Bytes;

public class ObserveNon
extends CoapResource {
    private byte[] data = null;
    private int dataCf = 0;
    private boolean wasUpdated = false;
    private String time;

    public ObserveNon(long notifyIntervalMillis) {
        super("obs-non");
        this.setObservable(true);
        this.getAttributes().setTitle("Observable resource which changes every 5 seconds");
        this.getAttributes().addResourceType("observe");
        this.getAttributes().setObservable();
        this.setObserveType(CoAP.Type.NON);
        Timer timer = new Timer("OBSERVE-NON", true);
        timer.schedule((TimerTask)new TimeTask(), 0L, notifyIntervalMillis);
    }

    private String getTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        Date time = new Date();
        return dateFormat.format(time);
    }

    @Override
    public void handleGET(CoapExchange exchange) {
        if (this.checkContentFormat(exchange, this.dataCf)) {
            exchange.setMaxAge(5L);
            if (this.wasUpdated) {
                exchange.respond(CoAP.ResponseCode.CONTENT, this.data, this.dataCf);
                this.wasUpdated = false;
            } else {
                exchange.respond(CoAP.ResponseCode.CONTENT, this.time, this.dataCf);
            }
        }
    }

    @Override
    public void handlePUT(CoapExchange exchange) {
        if (!exchange.getRequestOptions().hasContentFormat()) {
            exchange.respond(CoAP.ResponseCode.BAD_REQUEST, "Content-Format not set");
            return;
        }
        this.storeData(exchange.getRequestPayload(), exchange.getRequestOptions().getContentFormat());
        exchange.respond(CoAP.ResponseCode.CHANGED);
    }

    @Override
    public void handleDELETE(CoapExchange exchange) {
        this.wasUpdated = false;
        this.clearAndNotifyObserveRelations(CoAP.ResponseCode.NOT_FOUND);
        exchange.respond(CoAP.ResponseCode.DELETED);
    }

    private synchronized void storeData(byte[] payload, int format) {
        this.wasUpdated = true;
        if (format != this.dataCf) {
            this.clearAndNotifyObserveRelations(CoAP.ResponseCode.NOT_ACCEPTABLE);
        }
        this.data = payload != null ? payload : Bytes.EMPTY;
        this.dataCf = format;
        this.getAttributes().clearContentType();
        this.getAttributes().addContentType(this.dataCf);
        this.changed();
    }

    private class TimeTask
    extends TimerTask {
        private TimeTask() {
        }

        @Override
        public void run() {
            ObserveNon.this.time = ObserveNon.this.getTime();
            ObserveNon.this.dataCf = 0;
            ObserveNon.this.changed();
        }
    }
}

