/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests.resources;

import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.californium.elements.util.Bytes;

public class Create
extends CoapResource {
    private byte[] data = null;
    private int dataCf = -1;

    public Create() {
        super("create1");
        this.getAttributes().setTitle("Resource which does not exist yet (to perform atomic PUT)");
        this.setVisible(false);
    }

    @Override
    public void handlePUT(CoapExchange exchange) {
        if (this.data != null && exchange.getRequestOptions().hasIfNoneMatch()) {
            exchange.respond(CoAP.ResponseCode.PRECONDITION_FAILED);
            this.data = null;
        } else if (exchange.getRequestOptions().hasContentFormat()) {
            this.storeData(exchange.getRequestPayload(), exchange.getRequestOptions().getContentFormat());
            exchange.respond(CoAP.ResponseCode.CREATED);
        } else {
            exchange.respond(CoAP.ResponseCode.BAD_REQUEST, "Content-Format not set");
        }
    }

    @Override
    public void handleGET(CoapExchange exchange) {
        if (this.data != null) {
            int accept = exchange.getRequestOptions().getAccept();
            if (accept != -1 && accept != this.dataCf) {
                exchange.respond(CoAP.ResponseCode.NOT_ACCEPTABLE);
            } else {
                exchange.respond(CoAP.ResponseCode.CONTENT, this.data, this.dataCf);
            }
        } else {
            exchange.respond(CoAP.ResponseCode.NOT_FOUND);
        }
    }

    @Override
    public void handleDELETE(CoapExchange exchange) {
        this.data = null;
        this.setVisible(false);
        exchange.respond(CoAP.ResponseCode.DELETED);
    }

    private synchronized void storeData(byte[] payload, int cf) {
        this.data = payload != null ? payload : Bytes.EMPTY;
        this.dataCf = cf;
        this.getAttributes().clearContentType();
        this.getAttributes().addContentType(this.dataCf);
        this.getAttributes().setMaximumSizeEstimate(this.data.length);
        this.setVisible(true);
        this.changed();
    }
}

