/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.DataStreamReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptedStreamUtil {
    @Deprecated
    public static final String DEFAULT_CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";
    public static final int DEFAULT_KEY_SIZE_BITS = 128;
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptedStreamUtil.class);
    private static final String HMAC_ALGORITHM = "HmacSHA256";
    private static final byte[] EXPANSION_LABEL = "key expansion".getBytes();
    private static final int NONCE_SIZE = 16;
    private static final Map<Integer, CipherDefinition> CIPHER_DEFINITIONS = new HashMap<Integer, CipherDefinition>();
    private static final CipherDefinition DEFAULT_CIPHER_DEFINITION;
    private CipherDefinition writeCipherDefinition;
    private CipherDefinition readCipherDefinition;

    private static boolean addInternal(int id, String algorithm, int bits) {
        CipherDefinition definition = new CipherDefinition(id, algorithm, bits);
        CIPHER_DEFINITIONS.put(id, new CipherDefinition(id, algorithm, bits));
        return definition.supported;
    }

    private static CipherDefinition getCipherDefinition(String cipherAlgorithm, int keySizeBits) {
        for (CipherDefinition definition : CIPHER_DEFINITIONS.values()) {
            if (!definition.algorithm.equals(cipherAlgorithm) || definition.keySizeBits != keySizeBits) continue;
            return definition;
        }
        return null;
    }

    private static CipherDefinition getCipherDefinition(String spec) {
        for (CipherDefinition definition : CIPHER_DEFINITIONS.values()) {
            if (!definition.spec.equals(spec)) continue;
            return definition;
        }
        return null;
    }

    public static boolean add(int id, String algorithm, int bits) {
        CipherDefinition definitionId = CIPHER_DEFINITIONS.get(id);
        CipherDefinition definitionParam = EncryptedStreamUtil.getCipherDefinition(algorithm, bits);
        if (definitionId != null) {
            if (definitionId.equals(definitionParam)) {
                return definitionId.supported;
            }
            throw new IllegalArgumentException("0x" + Integer.toHexString(id) + " already in use for " + definitionId.algorithm + "/" + definitionId.keySizeBits + "!");
        }
        if (definitionParam != null) {
            throw new IllegalArgumentException(definitionParam.algorithm + "/" + definitionParam.keySizeBits + " already defined as 0x" + Integer.toHexString(id) + "!");
        }
        if (id < 61440 || id > 65279) {
            throw new IllegalArgumentException("0x" + Integer.toHexString(id) + " is not in custom range [0xf000-0xfeff]!");
        }
        return EncryptedStreamUtil.addInternal(id, algorithm, bits);
    }

    public EncryptedStreamUtil() {
        this.setDefaultWriteCipher();
    }

    public EncryptedStreamUtil(String spec) {
        this.setWriteCipher(spec);
    }

    public EncryptedStreamUtil(String cipherAlgorithm, int keySizeBits) {
        this.setWriteCipher(cipherAlgorithm, keySizeBits);
    }

    public String getWriteCipher() {
        return this.writeCipherDefinition.spec;
    }

    public String getReadCipher() {
        return this.readCipherDefinition == null ? null : this.readCipherDefinition.spec;
    }

    @Deprecated
    public void setCipher(String cipherAlgorithm, int keySizeBits) {
        try {
            this.setWriteCipher(cipherAlgorithm, keySizeBits);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void setDefaultWriteCipher() {
        this.writeCipherDefinition = DEFAULT_CIPHER_DEFINITION;
    }

    public void setWriteCipher(String cipherAlgorithm, int keySizeBits) {
        CipherDefinition definition = EncryptedStreamUtil.getCipherDefinition(cipherAlgorithm, keySizeBits);
        if (definition == null || !definition.supported) {
            throw new IllegalArgumentException(cipherAlgorithm + "/" + keySizeBits + " is not supported!");
        }
        this.writeCipherDefinition = definition;
    }

    public void setWriteCipher(String spec) {
        CipherDefinition definition = EncryptedStreamUtil.getCipherDefinition(spec);
        if (definition == null || !definition.supported) {
            throw new IllegalArgumentException(spec + " is not supported!");
        }
        this.writeCipherDefinition = definition;
    }

    private Cipher init(int mode, SecretKey password, byte[] seed) {
        CipherDefinition defintion = null;
        if (mode == 1) {
            defintion = this.writeCipherDefinition;
        } else if (mode == 2) {
            if (this.readCipherDefinition == null) {
                throw new IllegalArgumentException("Read cipher definition not available!");
            }
            defintion = this.readCipherDefinition;
        }
        if (defintion == null) {
            throw new IllegalArgumentException("Invalid mode!");
        }
        try {
            Mac hmac = Mac.getInstance(HMAC_ALGORITHM);
            hmac.init(password);
            int ivSize = 16;
            int keySizeBytes = (defintion.keySizeBits + 8 - 1) / 8;
            byte[] data = EncryptedStreamUtil.doExpansion(hmac, EXPANSION_LABEL, seed, keySizeBytes + ivSize);
            SecretKeySpec key = new SecretKeySpec(data, 0, keySizeBytes, "AES");
            AlgorithmParameterSpec parameterSpec = defintion.gcm ? new GCMParameterSpec(128, data, keySizeBytes, ivSize) : new IvParameterSpec(data, keySizeBytes, ivSize);
            Bytes.clear(data);
            Cipher cipher = Cipher.getInstance(defintion.algorithm);
            cipher.init(mode, (Key)key, parameterSpec);
            return cipher;
        }
        catch (GeneralSecurityException ex) {
            LOGGER.warn("encryption error:", ex);
            return null;
        }
    }

    public byte[] readSeed(InputStream in) {
        DataStreamReader reader = new DataStreamReader(in);
        int b = reader.read(8);
        if (b == 0) {
            return Bytes.EMPTY;
        }
        if (b == 16) {
            this.readCipherDefinition = EncryptedStreamUtil.getCipherDefinition("AES/CBC/128");
            return reader.readBytes(b);
        }
        int b2 = reader.read(8);
        int id = b << 8 | b2;
        CipherDefinition definition = CIPHER_DEFINITIONS.get(id);
        if (definition == null) {
            LOGGER.warn("Cipher {} is not available!", (Object)Integer.toHexString(id));
            return Bytes.EMPTY;
        }
        if (!definition.supported) {
            LOGGER.warn("Cipher {}/{} is not supported!", (Object)Integer.toHexString(id), (Object)definition.spec);
            return Bytes.EMPTY;
        }
        this.readCipherDefinition = definition;
        return reader.readVarBytes(8);
    }

    public InputStream prepare(InputStream in, SecretKey password) {
        return this.prepare(this.readSeed(in), in, password);
    }

    public InputStream prepare(byte[] seed, InputStream in, SecretKey password) {
        if (seed != null && seed.length > 0) {
            if (password == null) {
                LOGGER.warn("missing password!");
                return new ByteArrayInputStream(Bytes.EMPTY);
            }
            Cipher cipher = this.init(2, password, seed);
            if (cipher == null) {
                LOGGER.warn("crypto error!");
                return new ByteArrayInputStream(Bytes.EMPTY);
            }
            if (!(in = new CipherInputStream(in, cipher)).markSupported()) {
                in = new BufferedInputStream(in);
            }
        }
        return in;
    }

    public OutputStream prepare(OutputStream out, SecretKey password) throws IOException {
        return this.prepare(null, out, password);
    }

    public OutputStream prepare(byte[] seed, OutputStream out, SecretKey password) throws IOException {
        DatagramWriter writer = new DatagramWriter();
        if (password != null) {
            Cipher cipher;
            byte[] newSeed = new byte[seed == null ? 16 : seed.length];
            SecureRandom random = new SecureRandom();
            int count = 0;
            random.nextBytes(newSeed);
            while (seed != null && Arrays.equals(seed, newSeed)) {
                if (++count > 5) {
                    throw new IOException("Random seed failed!");
                }
                random.nextBytes(newSeed);
            }
            if (seed != null) {
                System.arraycopy(newSeed, 0, seed, 0, seed.length);
            }
            if ((cipher = this.init(1, password, newSeed)) != null) {
                writer.write(this.writeCipherDefinition.id, 16);
                writer.writeVarBytes(newSeed, 8);
                writer.writeTo(out);
                out = new CipherOutputStream(out, cipher);
            } else {
                LOGGER.warn("crypto error!");
                password = null;
            }
        }
        if (password == null) {
            writer.writeVarBytes(Bytes.EMPTY, 8);
            writer.writeTo(out);
        }
        return out;
    }

    private static final byte[] doExpansion(Mac hmac, byte[] label, byte[] seed, int length) {
        int offset = 0;
        int macLength = hmac.getMacLength();
        byte[] aAndSeed = new byte[macLength + label.length + seed.length];
        byte[] expansion = new byte[length];
        try {
            System.arraycopy(label, 0, aAndSeed, macLength, label.length);
            System.arraycopy(seed, 0, aAndSeed, macLength + label.length, seed.length);
            hmac.update(label);
            hmac.update(seed);
            while (true) {
                hmac.doFinal(aAndSeed, 0);
                hmac.update(aAndSeed);
                int nextOffset = offset + macLength;
                if (nextOffset > length) {
                    hmac.doFinal(aAndSeed, 0);
                    System.arraycopy(aAndSeed, 0, expansion, offset, length - offset);
                } else {
                    hmac.doFinal(expansion, offset);
                    if (nextOffset != length) {
                        offset = nextOffset;
                        hmac.update(aAndSeed, 0, macLength);
                        continue;
                    }
                }
                break;
            }
        }
        catch (ShortBufferException e) {
            e.printStackTrace();
        }
        Bytes.clear(aAndSeed);
        return expansion;
    }

    static {
        EncryptedStreamUtil.addInternal(513, DEFAULT_CIPHER_ALGORITHM, 128);
        EncryptedStreamUtil.addInternal(514, DEFAULT_CIPHER_ALGORITHM, 256);
        EncryptedStreamUtil.addInternal(769, "AES/GCM/NoPadding", 128);
        EncryptedStreamUtil.addInternal(770, "AES/GCM/NoPadding", 256);
        EncryptedStreamUtil.addInternal(1025, "ARIA/GCM/NoPadding", 128);
        EncryptedStreamUtil.addInternal(1026, "ARIA/GCM/NoPadding", 256);
        CipherDefinition def = CIPHER_DEFINITIONS.get(769);
        if (def == null || !def.supported) {
            def = CIPHER_DEFINITIONS.get(513);
        }
        DEFAULT_CIPHER_DEFINITION = def;
    }

    private static final class CipherDefinition {
        private final int id;
        private final String spec;
        private final String algorithm;
        private final int keySizeBits;
        private final boolean gcm;
        private final boolean supported;

        private CipherDefinition(int id, String algorithm, int keySizeBits) {
            String[] parts = algorithm.split("/");
            this.spec = parts[0] + "/" + parts[1] + "/" + keySizeBits;
            this.id = id;
            this.algorithm = algorithm;
            this.keySizeBits = keySizeBits;
            this.gcm = algorithm.contains("/GCM/");
            boolean supported = false;
            try {
                Cipher.getInstance(algorithm);
                supported = keySizeBits <= Cipher.getMaxAllowedKeyLength(algorithm);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                // empty catch block
            }
            this.supported = supported;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.algorithm == null ? 0 : this.algorithm.hashCode());
            result = 31 * result + this.id;
            result = 31 * result + this.keySizeBits;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CipherDefinition other = (CipherDefinition)obj;
            if (this.id != other.id) {
                return false;
            }
            if (this.keySizeBits != other.keySizeBits) {
                return false;
            }
            return !(this.algorithm == null ? other.algorithm != null : !this.algorithm.equals(other.algorithm));
        }
    }
}

