/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.NoPublicAPI;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.HelloExtension;
import org.eclipse.californium.scandium.dtls.cipher.XECDHECryptography;

@NoPublicAPI
public final class SupportedEllipticCurvesExtension
extends HelloExtension {
    private static final int LIST_LENGTH_BITS = 16;
    private static final int CURVE_BITS = 16;
    private final List<XECDHECryptography.SupportedGroup> supportedGroups;

    public SupportedEllipticCurvesExtension(List<XECDHECryptography.SupportedGroup> supportedGroups) {
        super(HelloExtension.ExtensionType.ELLIPTIC_CURVES);
        this.supportedGroups = supportedGroups;
    }

    public List<XECDHECryptography.SupportedGroup> getSupportedGroups() {
        return this.supportedGroups;
    }

    @Override
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder(super.toString(indent));
        String indentation = StringUtil.indentation(indent + 1);
        String indentation2 = StringUtil.indentation(indent + 2);
        sb.append(indentation).append("Elliptic Curves (").append(this.supportedGroups.size()).append(" curves):").append(StringUtil.lineSeparator());
        for (XECDHECryptography.SupportedGroup group : this.supportedGroups) {
            sb.append(indentation2).append("Elliptic Curve: ").append(group.name()).append(" (").append(group.getId()).append(")").append(StringUtil.lineSeparator());
        }
        return sb.toString();
    }

    @Override
    protected int getExtensionLength() {
        return 2 + this.supportedGroups.size() * 2;
    }

    @Override
    protected void writeExtensionTo(DatagramWriter writer) {
        int listLength = this.supportedGroups.size() * 2;
        writer.write(listLength, 16);
        for (XECDHECryptography.SupportedGroup group : this.supportedGroups) {
            writer.write(group.getId(), 16);
        }
    }

    public static SupportedEllipticCurvesExtension fromExtensionDataReader(DatagramReader extensionDataReader) {
        ArrayList<XECDHECryptography.SupportedGroup> groups = new ArrayList<XECDHECryptography.SupportedGroup>();
        int listLength = extensionDataReader.read(16);
        DatagramReader rangeReader = extensionDataReader.createRangeReader(listLength);
        while (rangeReader.bytesAvailable()) {
            int id = rangeReader.read(16);
            XECDHECryptography.SupportedGroup group = XECDHECryptography.SupportedGroup.fromId(id);
            if (group == null) continue;
            groups.add(group);
        }
        return new SupportedEllipticCurvesExtension(Collections.unmodifiableList(groups));
    }
}

