/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import org.eclipse.californium.core.network.Outbox;
import org.eclipse.californium.core.network.stack.BaseCoapStack;
import org.eclipse.californium.core.network.stack.BlockwiseLayer;
import org.eclipse.californium.core.network.stack.CongestionControlLayer;
import org.eclipse.californium.core.network.stack.ExchangeCleanupLayer;
import org.eclipse.californium.core.network.stack.Layer;
import org.eclipse.californium.core.network.stack.ObserveLayer;
import org.eclipse.californium.elements.EndpointContextMatcher;
import org.eclipse.californium.elements.config.Configuration;

public class CoapUdpStack
extends BaseCoapStack {
    public CoapUdpStack(String tag, Configuration config, EndpointContextMatcher matchingStrategy, Outbox outbox) {
        super(outbox);
        Layer[] layers = new Layer[]{new ExchangeCleanupLayer(config), new ObserveLayer(config), new BlockwiseLayer(tag, false, config, matchingStrategy), CongestionControlLayer.newImplementation(tag, config)};
        this.setLayers(layers);
    }

    public CoapUdpStack(String tag, Configuration config, Outbox outbox) {
        super(outbox);
        Layer[] layers = new Layer[]{this.createExchangeCleanupLayer(config), this.createObserveLayer(config), this.createBlockwiseLayer(tag, config), this.createReliabilityLayer(tag, config)};
        this.setLayers(layers);
    }

    protected Layer createExchangeCleanupLayer(Configuration config) {
        return new ExchangeCleanupLayer(config);
    }

    protected Layer createObserveLayer(Configuration config) {
        return new ObserveLayer(config);
    }

    protected Layer createBlockwiseLayer(String tag, Configuration config) {
        return new BlockwiseLayer(tag, false, config);
    }

    protected Layer createReliabilityLayer(String tag, Configuration config) {
        return CongestionControlLayer.newImplementation(tag, config);
    }
}

