/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import org.eclipse.californium.scandium.dtls.Cookie;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.util.ByteArrayUtils;
import org.eclipse.californium.scandium.util.DatagramReader;
import org.eclipse.californium.scandium.util.DatagramWriter;

public class HelloVerifyRequest
extends HandshakeMessage {
    private static final int VERSION_BITS = 8;
    private static final int COOKIE_LENGTH_BITS = 8;
    private ProtocolVersion serverVersion;
    private Cookie cookie;

    public HelloVerifyRequest(ProtocolVersion version, Cookie cookie) {
        this.serverVersion = version;
        this.cookie = cookie;
    }

    @Override
    public byte[] fragmentToByteArray() {
        DatagramWriter writer = new DatagramWriter();
        writer.write(this.serverVersion.getMajor(), 8);
        writer.write(this.serverVersion.getMinor(), 8);
        writer.write(this.cookie.length(), 8);
        writer.writeBytes(this.cookie.getCookie());
        return writer.toByteArray();
    }

    public static HandshakeMessage fromByteArray(byte[] byteArray) {
        DatagramReader reader = new DatagramReader(byteArray);
        int major = reader.read(8);
        int minor = reader.read(8);
        ProtocolVersion version = new ProtocolVersion(major, minor);
        int cookieLength = reader.read(8);
        Cookie cookie = new Cookie(reader.readBytes(cookieLength));
        return new HelloVerifyRequest(version, cookie);
    }

    @Override
    public HandshakeType getMessageType() {
        return HandshakeType.HELLO_VERIFY_REQUEST;
    }

    @Override
    public int getMessageLength() {
        return 3 + this.cookie.length();
    }

    public ProtocolVersion getServerVersion() {
        return this.serverVersion;
    }

    public Cookie getCookie() {
        return this.cookie;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("\t\tServer Version: " + this.serverVersion.getMajor() + ", " + this.serverVersion.getMinor() + "\n");
        sb.append("\t\tCookie Length: " + this.cookie.length() + "\n");
        sb.append("\t\tCookie: " + ByteArrayUtils.toHexString(this.cookie.getCookie()) + "\n");
        return sb.toString();
    }
}

