/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.californium.elements.RawData;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.ApplicationMessage;
import org.eclipse.californium.scandium.dtls.ChangeCipherSpecMessage;
import org.eclipse.californium.scandium.dtls.CompressionMethod;
import org.eclipse.californium.scandium.dtls.ContentType;
import org.eclipse.californium.scandium.dtls.DTLSConnectionState;
import org.eclipse.californium.scandium.dtls.DTLSFlight;
import org.eclipse.californium.scandium.dtls.DTLSMessage;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.FragmentedHandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.Random;
import org.eclipse.californium.scandium.dtls.Record;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.ECDHECryptography;
import org.eclipse.californium.scandium.util.ByteArrayUtils;

public abstract class Handshaker {
    protected static final Logger LOGGER = Logger.getLogger(Handshaker.class.getCanonicalName());
    private static final int MASTER_SECRET_LABEL = 1;
    private static final int KEY_EXPANSION_LABEL = 2;
    public static final int CLIENT_FINISHED_LABEL = 3;
    public static final int SERVER_FINISHED_LABEL = 4;
    public static final int TEST_LABEL = 5;
    public static final int TEST_LABEL_2 = 6;
    public static final int TEST_LABEL_3 = 7;
    protected boolean isClient;
    protected int state = -1;
    protected InetSocketAddress endpointAddress;
    protected ProtocolVersion usedProtocol;
    protected Random clientRandom;
    protected Random serverRandom;
    private CipherSuite cipherSuite;
    private CompressionMethod compressionMethod;
    protected CipherSuite.KeyExchangeAlgorithm keyExchange;
    protected ECDHECryptography ecdhe;
    private byte[] masterSecret;
    private SecretKey clientWriteMACKey;
    private SecretKey serverWriteMACKey;
    private IvParameterSpec clientWriteIV;
    private IvParameterSpec serverWriteIV;
    private SecretKey clientWriteKey;
    private SecretKey serverWriteKey;
    protected DTLSSession session = null;
    private int sequenceNumber = 0;
    private int nextReceiveSeq = 0;
    protected RawData message = null;
    protected Collection<Record> queuedMessages;
    protected Map<Integer, List<FragmentedHandshakeMessage>> fragmentedMessages = new HashMap<Integer, List<FragmentedHandshakeMessage>>();
    protected MessageDigest md;
    protected byte[] handshakeMessages = new byte[0];
    protected DTLSFlight lastFlight = null;
    protected PrivateKey privateKey;
    protected PublicKey publicKey;
    protected Certificate[] certificates;
    protected final Certificate[] rootCertificates;
    private int maxFragmentLength = 4096;

    public Handshaker(InetSocketAddress peerAddress, boolean isClient, DTLSSession session, Certificate[] rootCertificates) {
        this.endpointAddress = peerAddress;
        this.isClient = isClient;
        this.session = session;
        this.queuedMessages = new HashSet<Record>();
        this.rootCertificates = rootCertificates == null ? new Certificate[]{} : rootCertificates;
        try {
            this.md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.log(Level.SEVERE, "Could not initialize the message digest algorithm.", e);
        }
    }

    public abstract DTLSFlight processMessage(Record var1) throws HandshakeException;

    public abstract DTLSFlight getStartHandshakeMessage();

    protected void generateKeys(byte[] premasterSecret) {
        this.masterSecret = this.generateMasterSecret(premasterSecret);
        this.session.setMasterSecret(this.masterSecret);
        this.calculateKeys(this.masterSecret);
    }

    private void calculateKeys(byte[] masterSecret) {
        byte[] data = Handshaker.doPRF(masterSecret, 2, ByteArrayUtils.concatenate(this.serverRandom.getRandomBytes(), this.clientRandom.getRandomBytes()));
        if (this.cipherSuite == null) {
            this.cipherSuite = this.session.getCipherSuite();
        }
        int macKeyLength = this.cipherSuite.getBulkCipher().getMacKeyLength();
        int encKeyLength = this.cipherSuite.getBulkCipher().getEncKeyLength();
        int fixedIvLength = this.cipherSuite.getBulkCipher().getFixedIvLength();
        this.clientWriteMACKey = new SecretKeySpec(data, 0, macKeyLength, "Mac");
        this.serverWriteMACKey = new SecretKeySpec(data, macKeyLength, macKeyLength, "Mac");
        this.clientWriteKey = new SecretKeySpec(data, 2 * macKeyLength, encKeyLength, "AES");
        this.serverWriteKey = new SecretKeySpec(data, 2 * macKeyLength + encKeyLength, encKeyLength, "AES");
        this.clientWriteIV = new IvParameterSpec(data, 2 * macKeyLength + 2 * encKeyLength, fixedIvLength);
        this.serverWriteIV = new IvParameterSpec(data, 2 * macKeyLength + 2 * encKeyLength + fixedIvLength, fixedIvLength);
    }

    private byte[] generateMasterSecret(byte[] premasterSecret) {
        byte[] randomSeed = ByteArrayUtils.concatenate(this.clientRandom.getRandomBytes(), this.serverRandom.getRandomBytes());
        return Handshaker.doPRF(premasterSecret, 1, randomSeed);
    }

    protected byte[] generatePremasterSecretFromPSK(byte[] psk) {
        int length = psk.length;
        byte[] lengthField = new byte[]{(byte)(length >> 8), (byte)length};
        byte[] zero = ByteArrayUtils.padArray(new byte[0], (byte)0, length);
        byte[] premasterSecret = ByteArrayUtils.concatenate(lengthField, ByteArrayUtils.concatenate(zero, ByteArrayUtils.concatenate(lengthField, psk)));
        return premasterSecret;
    }

    public static byte[] doPRF(byte[] secret, int labelId, byte[] seed) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            switch (labelId) {
                case 1: {
                    String label = "master secret";
                    return Handshaker.doExpansion(md, secret, ByteArrayUtils.concatenate(label.getBytes(), seed), 48);
                }
                case 2: {
                    String label = "key expansion";
                    return Handshaker.doExpansion(md, secret, ByteArrayUtils.concatenate(label.getBytes(), seed), 128);
                }
                case 3: {
                    String label = "client finished";
                    return Handshaker.doExpansion(md, secret, ByteArrayUtils.concatenate(label.getBytes(), seed), 12);
                }
                case 4: {
                    String label = "server finished";
                    return Handshaker.doExpansion(md, secret, ByteArrayUtils.concatenate(label.getBytes(), seed), 12);
                }
                case 5: {
                    String label = "test label";
                    return Handshaker.doExpansion(md, secret, ByteArrayUtils.concatenate(label.getBytes(), seed), 100);
                }
                case 6: {
                    String label = "test label";
                    md = MessageDigest.getInstance("SHA-512");
                    return Handshaker.doExpansion(md, secret, ByteArrayUtils.concatenate(label.getBytes(), seed), 196);
                }
                case 7: {
                    String label = "test label";
                    md = MessageDigest.getInstance("SHA-384");
                    return Handshaker.doExpansion(md, secret, ByteArrayUtils.concatenate(label.getBytes(), seed), 148);
                }
            }
            LOGGER.severe("Unknwon label: " + labelId);
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.log(Level.SEVERE, "Message digest algorithm not available.", e);
            return null;
        }
    }

    protected static byte[] doExpansion(MessageDigest md, byte[] secret, byte[] data, int length) {
        double hashLength = 32.0;
        if (md.getAlgorithm().equals("SHA-1")) {
            hashLength = 20.0;
        } else if (md.getAlgorithm().equals("SHA-384")) {
            hashLength = 48.0;
        }
        int iterations = (int)Math.ceil((double)length / hashLength);
        byte[] expansion = new byte[]{};
        byte[] A = data;
        for (int i = 0; i < iterations; ++i) {
            A = Handshaker.doHMAC(md, secret, A);
            expansion = ByteArrayUtils.concatenate(expansion, Handshaker.doHMAC(md, secret, ByteArrayUtils.concatenate(A, data)));
        }
        return ByteArrayUtils.truncate(expansion, length);
    }

    public static byte[] doHMAC(MessageDigest md, byte[] secret, byte[] data) {
        int B = 64;
        if (md.getAlgorithm().equals("SHA-512") || md.getAlgorithm().equals("SHA-384")) {
            B = 128;
        }
        byte[] ipad = new byte[B];
        Arrays.fill(ipad, (byte)54);
        byte[] opad = new byte[B];
        Arrays.fill(opad, (byte)92);
        byte[] step1 = secret;
        if (secret.length < B) {
            step1 = ByteArrayUtils.padArray(secret, (byte)0, B);
        } else if (secret.length > B) {
            md.update(secret);
            step1 = md.digest();
            md.reset();
            step1 = ByteArrayUtils.padArray(step1, (byte)0, B);
        }
        byte[] step2 = ByteArrayUtils.xorArrays(step1, ipad);
        byte[] step3 = ByteArrayUtils.concatenate(step2, data);
        md.update(step3);
        byte[] step4 = md.digest();
        md.reset();
        byte[] step5 = ByteArrayUtils.xorArrays(step1, opad);
        byte[] step6 = ByteArrayUtils.concatenate(step5, step4);
        md.update(step6);
        byte[] step7 = md.digest();
        return step7;
    }

    protected void setCurrentReadState() {
        DTLSConnectionState connectionState = this.isClient ? new DTLSConnectionState(this.cipherSuite, this.compressionMethod, this.serverWriteKey, this.serverWriteIV, this.serverWriteMACKey) : new DTLSConnectionState(this.cipherSuite, this.compressionMethod, this.clientWriteKey, this.clientWriteIV, this.clientWriteMACKey);
        this.session.setReadState(connectionState);
    }

    protected void setCurrentWriteState() {
        DTLSConnectionState connectionState = this.isClient ? new DTLSConnectionState(this.cipherSuite, this.compressionMethod, this.clientWriteKey, this.clientWriteIV, this.clientWriteMACKey) : new DTLSConnectionState(this.cipherSuite, this.compressionMethod, this.serverWriteKey, this.serverWriteIV, this.serverWriteMACKey);
        this.session.setWriteState(connectionState);
    }

    protected List<Record> wrapMessage(DTLSMessage fragment) {
        ArrayList<Record> records = new ArrayList<Record>();
        ContentType type = null;
        if (fragment instanceof ApplicationMessage) {
            type = ContentType.APPLICATION_DATA;
        } else if (fragment instanceof AlertMessage) {
            type = ContentType.ALERT;
        } else if (fragment instanceof ChangeCipherSpecMessage) {
            type = ContentType.CHANGE_CIPHER_SPEC;
        } else if (fragment instanceof HandshakeMessage) {
            type = ContentType.HANDSHAKE;
            HandshakeMessage handshakeMessage = (HandshakeMessage)fragment;
            this.setSequenceNumber(handshakeMessage);
            byte[] messageBytes = handshakeMessage.fragmentToByteArray();
            if (messageBytes.length > this.maxFragmentLength) {
                int messageSeq = handshakeMessage.getMessageSeq();
                int numFragments = messageBytes.length / this.maxFragmentLength + 1;
                int offset = 0;
                for (int i = 0; i < numFragments; ++i) {
                    int fragmentLength = this.maxFragmentLength;
                    if (offset + fragmentLength > messageBytes.length) {
                        fragmentLength = messageBytes.length - offset;
                    }
                    byte[] fragmentBytes = new byte[fragmentLength];
                    System.arraycopy(messageBytes, offset, fragmentBytes, 0, fragmentLength);
                    FragmentedHandshakeMessage fragmentedMessage = new FragmentedHandshakeMessage(fragmentBytes, handshakeMessage.getMessageType(), offset, messageBytes.length);
                    fragmentedMessage.setMessageSeq(messageSeq);
                    offset += fragmentBytes.length;
                    records.add(new Record(type, this.session.getWriteEpoch(), this.session.getSequenceNumber(), fragmentedMessage, this.session));
                }
            }
        }
        if (records.isEmpty()) {
            records.add(new Record(type, this.session.getWriteEpoch(), this.session.getSequenceNumber(), fragment, this.session));
        }
        return records;
    }

    protected boolean processMessageNext(Record record) throws HandshakeException {
        int epoch = record.getEpoch();
        if (epoch < this.session.getReadEpoch()) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Discarded message from " + this.endpointAddress.toString() + " due to older epoch.");
            }
            return false;
        }
        if (epoch == this.session.getReadEpoch()) {
            DTLSMessage fragment = record.getFragment();
            if (fragment instanceof AlertMessage) {
                return true;
            }
            if (fragment instanceof ChangeCipherSpecMessage) {
                return true;
            }
            if (fragment instanceof HandshakeMessage) {
                int messageSeq = ((HandshakeMessage)fragment).getMessageSeq();
                if (messageSeq == this.nextReceiveSeq) {
                    if (!(fragment instanceof FragmentedHandshakeMessage)) {
                        this.incrementNextReceiveSeq();
                    }
                    return true;
                }
                if (messageSeq > this.nextReceiveSeq) {
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.info("Queued newer message from same epoch, message_seq: " + messageSeq + ", next_receive_seq: " + this.nextReceiveSeq);
                    }
                    this.queuedMessages.add(record);
                    return false;
                }
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Discarded message due to older message_seq: " + messageSeq + ", next_receive_seq: " + this.nextReceiveSeq);
                }
                return false;
            }
            return false;
        }
        this.queuedMessages.add(record);
        return false;
    }

    protected HandshakeMessage handleFragmentation(FragmentedHandshakeMessage fragment) throws HandshakeException {
        HandshakeMessage reassembledMessage = null;
        int messageSeq = fragment.getMessageSeq();
        if (this.fragmentedMessages.get(messageSeq) == null) {
            this.fragmentedMessages.put(messageSeq, new ArrayList());
        }
        this.fragmentedMessages.get(messageSeq).add(fragment);
        reassembledMessage = this.reassembleFragments(messageSeq, fragment.getMessageLength(), fragment.getMessageType(), this.session);
        if (reassembledMessage != null) {
            this.incrementNextReceiveSeq();
            this.fragmentedMessages.remove(messageSeq);
        }
        return reassembledMessage;
    }

    protected HandshakeMessage reassembleFragments(int messageSeq, int totalLength, HandshakeType type, DTLSSession session) throws HandshakeException {
        List<FragmentedHandshakeMessage> fragments = this.fragmentedMessages.get(messageSeq);
        HandshakeMessage message = null;
        Collections.sort(fragments, new Comparator<FragmentedHandshakeMessage>(){

            @Override
            public int compare(FragmentedHandshakeMessage o1, FragmentedHandshakeMessage o2) {
                if (o1.getFragmentOffset() == o2.getFragmentOffset()) {
                    return 0;
                }
                if (o1.getFragmentOffset() < o2.getFragmentOffset()) {
                    return -1;
                }
                return 1;
            }
        });
        byte[] reassembly = new byte[]{};
        int offset = 0;
        for (FragmentedHandshakeMessage fragmentedHandshakeMessage : fragments) {
            int fragmentOffset = fragmentedHandshakeMessage.getFragmentOffset();
            int fragmentLength = fragmentedHandshakeMessage.getFragmentLength();
            if (fragmentOffset == offset) {
                reassembly = ByteArrayUtils.concatenate(reassembly, fragmentedHandshakeMessage.fragmentToByteArray());
                offset = reassembly.length;
                continue;
            }
            if (fragmentOffset >= offset || fragmentOffset + fragmentLength <= offset) continue;
            int newOffset = offset - fragmentOffset;
            int newLength = fragmentLength - newOffset;
            byte[] newBytes = new byte[newLength];
            System.arraycopy(fragmentedHandshakeMessage.fragmentToByteArray(), newOffset, newBytes, 0, newLength);
            reassembly = ByteArrayUtils.concatenate(reassembly, newBytes);
            offset = reassembly.length;
        }
        if (reassembly.length == totalLength) {
            FragmentedHandshakeMessage wholeMessage = new FragmentedHandshakeMessage(type, totalLength, messageSeq, 0, reassembly);
            reassembly = wholeMessage.toByteArray();
            CipherSuite.KeyExchangeAlgorithm keyExchangeAlgorithm = CipherSuite.KeyExchangeAlgorithm.NULL;
            boolean receiveRawPublicKey = false;
            if (session != null) {
                keyExchangeAlgorithm = session.getKeyExchange();
                receiveRawPublicKey = session.receiveRawPublicKey();
            }
            message = HandshakeMessage.fromByteArray(reassembly, keyExchangeAlgorithm, receiveRawPublicKey);
        }
        return message;
    }

    public CipherSuite getCipherSuite() {
        return this.cipherSuite;
    }

    public void setCipherSuite(CipherSuite cipherSuite) {
        this.cipherSuite = cipherSuite;
        this.keyExchange = cipherSuite.getKeyExchange();
        this.session.setKeyExchange(this.keyExchange);
        this.session.setCipherSuite(cipherSuite);
    }

    public byte[] getMasterSecret() {
        return this.masterSecret;
    }

    public SecretKey getClientWriteMACKey() {
        return this.clientWriteMACKey;
    }

    public SecretKey getServerWriteMACKey() {
        return this.serverWriteMACKey;
    }

    public IvParameterSpec getClientWriteIV() {
        return this.clientWriteIV;
    }

    public IvParameterSpec getServerWriteIV() {
        return this.serverWriteIV;
    }

    public SecretKey getClientWriteKey() {
        return this.clientWriteKey;
    }

    public SecretKey getServerWriteKey() {
        return this.serverWriteKey;
    }

    public DTLSSession getSession() {
        return this.session;
    }

    public void setSession(DTLSSession session) {
        this.session = session;
    }

    public void setSequenceNumber(HandshakeMessage message) {
        message.setMessageSeq(this.sequenceNumber);
        ++this.sequenceNumber;
    }

    public RawData getMessage() {
        return this.message;
    }

    public void setMessage(RawData message) {
        this.message = message;
    }

    public int getNextReceiveSeq() {
        return this.nextReceiveSeq;
    }

    public void incrementNextReceiveSeq() {
        ++this.nextReceiveSeq;
    }

    public CompressionMethod getCompressionMethod() {
        return this.compressionMethod;
    }

    public void setCompressionMethod(CompressionMethod compressionMethod) {
        this.compressionMethod = compressionMethod;
        this.session.setCompressionMethod(compressionMethod);
    }

    public int getMaxFragmentLength() {
        return this.maxFragmentLength;
    }

    public void setMaxFragmentLength(int maxFragmentLength) {
        this.maxFragmentLength = maxFragmentLength;
    }
}

