/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.util.ByteArrayUtils;

public class FragmentedHandshakeMessage
extends HandshakeMessage {
    private byte[] fragmentedBytes;
    private HandshakeType type;
    private int messageLength;

    public FragmentedHandshakeMessage(HandshakeType type, int messageLength, int messageSeq, int fragmentOffset, byte[] fragmentedBytes) {
        this.type = type;
        this.messageLength = messageLength;
        this.fragmentedBytes = fragmentedBytes;
        this.setMessageSeq(messageSeq);
        this.setFragmentOffset(fragmentOffset);
        this.setFragmentLength(fragmentedBytes.length);
    }

    public FragmentedHandshakeMessage(byte[] fragmentedBytes, HandshakeType type, int fragmentOffset, int messageLength) {
        this.fragmentedBytes = fragmentedBytes;
        this.type = type;
        this.setFragmentOffset(fragmentOffset);
        this.setFragmentLength(fragmentedBytes.length);
        this.messageLength = messageLength;
    }

    @Override
    public HandshakeType getMessageType() {
        return this.type;
    }

    @Override
    public int getMessageLength() {
        return this.messageLength;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("\t\t\tFragmented Handshake Message: " + this.fragmentedBytes.length + " bytes\n");
        sb.append("\t\t\t\t" + ByteArrayUtils.toHexString(this.fragmentedBytes) + "\n");
        return sb.toString();
    }

    @Override
    public byte[] fragmentToByteArray() {
        return this.fragmentedBytes;
    }
}

