/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.util.Arrays;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.Handshaker;
import org.eclipse.californium.scandium.util.ByteArrayUtils;
import org.eclipse.californium.scandium.util.DatagramReader;
import org.eclipse.californium.scandium.util.DatagramWriter;

public class Finished
extends HandshakeMessage {
    private byte[] verifyData;

    public Finished(byte[] masterSecret, boolean isClient, byte[] handshakeHash) {
        this.verifyData = this.getVerifyData(masterSecret, isClient, handshakeHash);
    }

    public Finished(byte[] verifyData) {
        this.verifyData = verifyData;
    }

    public void verifyData(byte[] masterSecret, boolean isClient, byte[] handshakeHash) throws HandshakeException {
        byte[] myVerifyData = this.getVerifyData(masterSecret, isClient, handshakeHash);
        boolean verified = Arrays.equals(myVerifyData, this.verifyData);
        if (!verified) {
            String message = "Could not verify the finished message:\nExpected: " + ByteArrayUtils.toHexString(myVerifyData) + "\nReceived: " + ByteArrayUtils.toHexString(this.verifyData);
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE);
            throw new HandshakeException(message, alert);
        }
    }

    private byte[] getVerifyData(byte[] masterSecret, boolean isClient, byte[] handshakeHash) {
        byte[] data = null;
        int labelId = isClient ? 3 : 4;
        data = Handshaker.doPRF(masterSecret, labelId, handshakeHash);
        return data;
    }

    @Override
    public HandshakeType getMessageType() {
        return HandshakeType.FINISHED;
    }

    @Override
    public int getMessageLength() {
        return this.verifyData.length;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\t\tVerify Data: " + ByteArrayUtils.toHexString(this.verifyData) + "\n");
        return sb.toString();
    }

    @Override
    public byte[] fragmentToByteArray() {
        DatagramWriter writer = new DatagramWriter();
        writer.writeBytes(this.verifyData);
        return writer.toByteArray();
    }

    public static HandshakeMessage fromByteArray(byte[] byteArray) {
        DatagramReader reader = new DatagramReader(byteArray);
        byte[] verifyData = reader.readBytesLeft();
        return new Finished(verifyData);
    }
}

