/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.server;

import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.observe.ObserveManager;
import org.eclipse.californium.core.observe.ObserveRelation;
import org.eclipse.californium.core.observe.ObservingEndpoint;
import org.eclipse.californium.core.server.MessageDeliverer;
import org.eclipse.californium.core.server.resources.Resource;

public class ServerMessageDeliverer
implements MessageDeliverer {
    private static final Logger LOGGER = Logger.getLogger(ServerMessageDeliverer.class.getCanonicalName());
    private final Resource root;
    private ObserveManager observeManager = new ObserveManager();

    public ServerMessageDeliverer(Resource root) {
        this.root = root;
    }

    @Override
    public void deliverRequest(final Exchange exchange) {
        Request request = exchange.getRequest();
        List<String> path = request.getOptions().getUriPath();
        final Resource resource = this.findResource(path);
        if (resource != null) {
            this.checkForObserveOption(exchange, resource);
            ExecutorService executor = resource.getExecutor();
            if (executor != null) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        resource.handleRequest(exchange);
                    }
                });
            } else {
                resource.handleRequest(exchange);
            }
        } else {
            LOGGER.info("Did not find resource " + path.toString());
            exchange.sendResponse(new Response(CoAP.ResponseCode.NOT_FOUND));
        }
    }

    private void checkForObserveOption(Exchange exchange, Resource resource) {
        Request request = exchange.getRequest();
        if (request.getCode() != CoAP.Code.GET) {
            return;
        }
        InetSocketAddress source = new InetSocketAddress(request.getSource(), request.getSourcePort());
        if (request.getOptions().hasObserve() && resource.isObservable()) {
            ObserveRelation relation;
            if (request.getOptions().getObserve() == 0) {
                LOGGER.finer("Initiate an observe relation between " + request.getSource() + ":" + request.getSourcePort() + " and resource " + resource.getURI());
                ObservingEndpoint remote = this.observeManager.findObservingEndpoint(source);
                ObserveRelation relation2 = new ObserveRelation(remote, resource, exchange);
                remote.addObserveRelation(relation2);
                exchange.setRelation(relation2);
            } else if (request.getOptions().getObserve() == 1 && (relation = this.observeManager.getRelation(source, request.getToken())) != null) {
                relation.cancel();
            }
        }
    }

    private Resource findResource(List<String> list) {
        String name;
        Resource current;
        LinkedList<String> path = new LinkedList<String>(list);
        for (current = this.root; !path.isEmpty() && current != null; current = current.getChild(name)) {
            name = path.removeFirst();
        }
        return current;
    }

    @Override
    public void deliverResponse(Exchange exchange, Response response) {
        if (response == null) {
            throw new NullPointerException();
        }
        if (exchange == null) {
            throw new NullPointerException();
        }
        if (exchange.getRequest() == null) {
            throw new NullPointerException();
        }
        exchange.getRequest().setResponse(response);
    }
}

