/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core;

import java.util.concurrent.ThreadFactory;
import org.eclipse.californium.core.CoapResponse;
import org.eclipse.californium.core.coap.MediaTypeRegistry;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;

public class Utils {
    private Utils() {
    }

    public static String toHexString(byte[] bytes) {
        if (bytes == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }

    public static String prettyPrint(Request r) {
        StringBuilder sb = new StringBuilder();
        sb.append("==[ CoAP Request ]=============================================\n");
        sb.append(String.format("MID    : %d\n", r.getMID()));
        sb.append(String.format("Token  : %s\n", r.getTokenString()));
        sb.append(String.format("Type   : %s\n", r.getType().toString()));
        sb.append(String.format("Method : %s\n", r.getCode().toString()));
        sb.append(String.format("Options: %s\n", r.getOptions().toString()));
        sb.append(String.format("Payload: %d Bytes\n", r.getPayloadSize()));
        if (r.getPayloadSize() > 0 && MediaTypeRegistry.isPrintable(r.getOptions().getContentFormat())) {
            sb.append("---------------------------------------------------------------");
            sb.append(r.getPayloadString());
        }
        sb.append("===============================================================");
        return sb.toString();
    }

    public static String prettyPrint(CoapResponse r) {
        return Utils.prettyPrint(r.advanced());
    }

    public static String prettyPrint(Response r) {
        StringBuilder sb = new StringBuilder();
        sb.append("==[ CoAP Response ]============================================\n");
        sb.append(String.format("MID    : %d\n", r.getMID()));
        sb.append(String.format("Token  : %s\n", r.getTokenString()));
        sb.append(String.format("Type   : %s\n", r.getType().toString()));
        sb.append(String.format("Status : %s\n", r.getCode().toString()));
        sb.append(String.format("Options: %s\n", r.getOptions().toString()));
        sb.append(String.format("Payload: %d Bytes\n", r.getPayloadSize()));
        if (r.getPayloadSize() > 0 && MediaTypeRegistry.isPrintable(r.getOptions().getContentFormat())) {
            sb.append("---------------------------------------------------------------\n");
            sb.append(r.getPayloadString());
            sb.append("\n");
        }
        sb.append("===============================================================");
        return sb.toString();
    }

    public static class DaemonThreadFactory
    implements ThreadFactory {
        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            return thread;
        }
    }
}

