/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.CompressionMethod;
import org.eclipse.californium.scandium.dtls.DTLSConnectionState;
import org.eclipse.californium.scandium.dtls.Record;
import org.eclipse.californium.scandium.dtls.cipher.CbcBlockCipher;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.util.SecretSerializationUtil;
import org.eclipse.californium.scandium.util.SecretUtil;

public class DtlsBlockConnectionState
extends DTLSConnectionState {
    private final SecretKey encryptionKey;
    private final SecretKey macKey;

    DtlsBlockConnectionState(CipherSuite cipherSuite, CompressionMethod compressionMethod, SecretKey encryptionKey, SecretKey macKey) {
        super(cipherSuite, compressionMethod);
        if (encryptionKey == null) {
            throw new NullPointerException("Encryption key must not be null!");
        }
        if (macKey == null) {
            throw new NullPointerException("MAC key must not be null!");
        }
        this.encryptionKey = SecretUtil.create(encryptionKey);
        this.macKey = SecretUtil.create(macKey);
    }

    @Override
    public void destroy() throws DestroyFailedException {
        SecretUtil.destroy(this.encryptionKey);
        SecretUtil.destroy(this.macKey);
    }

    @Override
    public boolean isDestroyed() {
        return SecretUtil.isDestroyed(this.macKey) && SecretUtil.isDestroyed(this.encryptionKey);
    }

    @Override
    public byte[] encrypt(Record record, byte[] fragment) throws GeneralSecurityException {
        byte[] additionalData = record.generateAdditionalData(fragment.length);
        return CbcBlockCipher.encrypt(this.cipherSuite, this.encryptionKey, this.macKey, additionalData, fragment);
    }

    @Override
    public byte[] decrypt(Record record, byte[] ciphertextFragment) throws GeneralSecurityException {
        if (ciphertextFragment == null) {
            throw new NullPointerException("Ciphertext must not be null");
        }
        if (ciphertextFragment.length % this.cipherSuite.getRecordIvLength() != 0) {
            throw new GeneralSecurityException("Ciphertext doesn't fit block size!");
        }
        if (ciphertextFragment.length < this.cipherSuite.getRecordIvLength() + this.cipherSuite.getMacLength() + 1) {
            throw new GeneralSecurityException("Ciphertext too short!");
        }
        byte[] additionalData = record.generateAdditionalData(0);
        return CbcBlockCipher.decrypt(this.cipherSuite, this.encryptionKey, this.macKey, additionalData, ciphertextFragment);
    }

    void initMac(Mac mac) throws InvalidKeyException {
        mac.init(this.macKey);
    }

    int getMacKeyLength() {
        byte[] encoded = this.macKey.getEncoded();
        Bytes.clear(encoded);
        return encoded.length;
    }

    public final String toString() {
        StringBuilder b = new StringBuilder("DtlsBlockConnectionState:").append(StringUtil.lineSeparator());
        String indentation = StringUtil.indentation(1);
        b.append(indentation).append("Cipher suite: ").append((Object)this.cipherSuite).append(StringUtil.lineSeparator());
        b.append(indentation).append("Compression method: ").append((Object)this.compressionMethod).append(StringUtil.lineSeparator());
        b.append(indentation).append("MAC key: ").append(this.macKey == null ? "null" : "not null").append(StringUtil.lineSeparator());
        b.append(indentation).append("Encryption key: ").append(this.encryptionKey == null ? "null" : "not null").append(StringUtil.lineSeparator());
        return b.toString();
    }

    @Override
    public void writeTo(DatagramWriter writer) {
        SecretSerializationUtil.write(writer, this.macKey);
        SecretSerializationUtil.write(writer, this.encryptionKey);
    }

    DtlsBlockConnectionState(CipherSuite cipherSuite, CompressionMethod compressionMethod, DatagramReader reader) {
        super(cipherSuite, compressionMethod);
        this.macKey = SecretSerializationUtil.readSecretKey(reader);
        this.encryptionKey = SecretSerializationUtil.readSecretKey(reader);
    }
}

