/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests.resources;

import org.eclipse.californium.core.CoapExchange;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.Utils;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.oscore.HashMapCtxDB;
import org.eclipse.californium.oscore.OSCoreCtx;

public class OscoreInfo
extends CoapResource {
    private HashMapCtxDB db;
    private byte[] serverRid;

    public OscoreInfo(HashMapCtxDB db, byte[] serverRid) {
        super("oscoreInfo", true);
        this.getAttributes().setTitle("Resource for retreiving the OSCORE security material used by this server");
        this.addSupportedContentFormats(0);
        this.db = db;
        this.serverRid = serverRid;
    }

    @Override
    public void handleGET(CoapExchange exchange) {
        StringBuilder payload = new StringBuilder();
        OSCoreCtx serverCtx = this.db.getContext(this.serverRid);
        payload.append("\nExpected OSCORE configuration: ");
        payload.append("\n(Usage of Appendix B.2 is also possible) ");
        payload.append("\nID Context: ");
        payload.append(Utils.toHexString(serverCtx.getIdContext()));
        int replayWindow = serverCtx.getRecipientReplayWindow();
        int offset = serverCtx.getRecipientReplaySize() - Integer.numberOfLeadingZeros(replayWindow);
        payload.append("\nClient Sender Sequence Number: ");
        payload.append(serverCtx.getLowestRecipientSeq() + offset);
        exchange.setMaxAge(30L);
        exchange.respond(CoAP.ResponseCode.CONTENT, payload.toString(), 0);
    }
}

