/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests.resources;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.californium.core.CoapExchange;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.coap.CoAP;

public class ObservePumping
extends CoapResource {
    private static final String PADDING = "----------------------------------------------------------------";
    private String time;

    public ObservePumping(CoAP.Type type, long notifyIntervalMillis) {
        super("obs-pumping" + (type == CoAP.Type.NON ? "-non" : ""));
        this.setObservable(true);
        this.getAttributes().setTitle("Observable resource which changes every 5 seconds");
        this.getAttributes().addResourceType("observe");
        this.getAttributes().setObservable();
        this.setObserveType(type);
        this.addSupportedContentFormats(0);
        Timer timer = new Timer("OBSERVE-PUMP", true);
        timer.schedule((TimerTask)new TimeTask(), 0L, notifyIntervalMillis);
    }

    private String getTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        Date time = new Date();
        return dateFormat.format(time);
    }

    @Override
    public void handleGET(CoapExchange exchange) {
        exchange.setMaxAge(5L);
        exchange.respond(CoAP.ResponseCode.CONTENT, this.time, 0);
    }

    private class TimeTask
    extends TimerTask {
        private TimeTask() {
        }

        @Override
        public void run() {
            if (Math.random() > 0.5) {
                ObservePumping.this.time = String.format("%.31s\n%19s\n%.31s\n", ObservePumping.PADDING, ObservePumping.this.getTime(), ObservePumping.PADDING);
            } else if (Math.random() > 0.5) {
                ObservePumping.this.time = String.format("%.63s\n%35s\n%.63s\n", ObservePumping.PADDING, ObservePumping.this.getTime(), ObservePumping.PADDING);
            } else {
                ObservePumping.this.time = String.format("%s", ObservePumping.this.getTime());
            }
            ObservePumping.this.changed();
        }
    }
}

