/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests.resources;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.californium.core.CoapExchange;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.coap.CoAP;

public class ObserveLarge
extends CoapResource {
    private static final String PADDING = "----------------------------------------------------------------";
    private String time;

    public ObserveLarge(long notifyIntervalMillis) {
        super("obs-large");
        this.setObservable(true);
        this.getAttributes().setTitle("Observable resource which changes every 5 seconds");
        this.getAttributes().addResourceType("observe");
        this.getAttributes().setObservable();
        this.setObserveType(CoAP.Type.CON);
        this.addSupportedContentFormats(0);
        Timer timer = new Timer("OBSERVE-LARGE", true);
        timer.schedule((TimerTask)new TimeTask(), 0L, notifyIntervalMillis);
    }

    private String getTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        Date time = new Date();
        return dateFormat.format(time);
    }

    @Override
    public void handleGET(CoapExchange exchange) {
        exchange.setMaxAge(5L);
        exchange.respond(CoAP.ResponseCode.CONTENT, this.time, 0);
    }

    private class TimeTask
    extends TimerTask {
        private TimeTask() {
        }

        @Override
        public void run() {
            ObserveLarge.this.time = String.format("%s\n%-32s\n%s", ObserveLarge.PADDING, ObserveLarge.this.getTime(), ObserveLarge.PADDING);
            ObserveLarge.this.changed();
        }
    }
}

