/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap.option;

import java.util.Arrays;
import org.eclipse.californium.core.coap.option.OptionDefinition;

public abstract class BaseOptionDefinition
implements OptionDefinition {
    private static final int[] LENGTHS = new int[]{0, 65804};
    private final int number;
    private final String name;
    private final boolean singleValue;
    private final int[] lengths;

    protected BaseOptionDefinition(int number, String name, boolean singleValue, int[] lengths) {
        if (number > 65535 || number < 0) {
            throw new IllegalArgumentException(number + " invalid option number!");
        }
        this.number = number;
        this.name = name;
        this.singleValue = singleValue;
        if (lengths == null || lengths.length == 0) {
            this.lengths = LENGTHS;
        } else if (lengths.length == 1) {
            this.lengths = new int[2];
            this.lengths[0] = lengths[0];
            this.lengths[1] = lengths[0];
        } else {
            this.lengths = Arrays.copyOf(lengths, 2);
        }
    }

    @Override
    public boolean isSingleValue() {
        return this.singleValue;
    }

    @Override
    public void assertValueLength(int length) {
        int min = this.lengths[0];
        int max = this.lengths[1];
        if (length < min || length > max) {
            if (min == max) {
                if (min == 0) {
                    throw new IllegalArgumentException("Option " + this.name + " value of " + length + " bytes must be empty.");
                }
                throw new IllegalArgumentException("Option " + this.name + " value of " + length + " bytes must be " + min + " bytes.");
            }
            throw new IllegalArgumentException("Option " + this.name + " value of " + length + " bytes must be in range of [" + min + "-" + max + "] bytes.");
        }
    }

    @Override
    public String toString() {
        return this.name + "/" + (Object)((Object)this.getFormat());
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

