/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cose;

import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.californium.cose.AlgorithmID;
import org.eclipse.californium.cose.CoseException;
import org.eclipse.californium.cose.HeaderKeys;
import org.eclipse.californium.cose.Message;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.scandium.dtls.cipher.CCMBlockCipher;
import org.eclipse.californium.scandium.dtls.cipher.ThreadLocalCipher;

public abstract class EncryptCommon
extends Message {
    private static final int AES_CCM_16_IV_LENGTH = 13;
    private static final int AES_CCM_64_IV_LENGTH = 7;
    private static final int AES_GCM_IV_LENGTH = 12;
    private static final int CHACHA_POLY_IV_LENGTH = 12;
    private static final String AES_SPEC = "AES";
    private static final String AES_GCM_SPEC = "AES/GCM/NoPadding";
    private static final String CHACHA_SPEC = "ChaCha20";
    private static final String CHACHA_POLY_SPEC = "ChaCha20-Poly1305";
    private static final ThreadLocalCipher AES_GCM_CIPHER = new ThreadLocalCipher("AES/GCM/NoPadding");
    private static final ThreadLocalCipher CHACHA_POLY_CIPHER = new ThreadLocalCipher("ChaCha20-Poly1305");
    protected String context;
    protected byte[] rgbEncrypt;

    protected byte[] decryptWithKey(byte[] rgbKey) throws CoseException {
        CBORObject algX = this.findAttribute(HeaderKeys.Algorithm);
        AlgorithmID alg = AlgorithmID.FromCBOR(algX);
        if (this.rgbEncrypt == null) {
            throw new CoseException("No Encrypted Content Specified");
        }
        this.validateObjectState(rgbKey);
        switch (alg) {
            case AES_CCM_16_64_128: 
            case AES_CCM_16_128_128: 
            case AES_CCM_16_64_256: 
            case AES_CCM_16_128_256: 
            case AES_CCM_64_64_128: 
            case AES_CCM_64_128_128: 
            case AES_CCM_64_64_256: 
            case AES_CCM_64_128_256: {
                this.AES_CCM_Decrypt(alg, rgbKey);
                break;
            }
            case AES_GCM_128: 
            case AES_GCM_192: 
            case AES_GCM_256: {
                this.AES_GCM_Decrypt(alg, rgbKey);
                break;
            }
            case CHACHA20_POLY1305: {
                this.ChaCha20_Poly1305_Decrypt(alg, rgbKey);
                break;
            }
        }
        return this.rgbContent;
    }

    void encryptWithKey(byte[] rgbKey) throws CoseException, IllegalStateException {
        CBORObject algX = this.findAttribute(HeaderKeys.Algorithm);
        AlgorithmID alg = AlgorithmID.FromCBOR(algX);
        if (this.rgbContent == null) {
            throw new CoseException("No Content Specified");
        }
        this.validateObjectState(rgbKey);
        switch (alg) {
            case AES_CCM_16_64_128: 
            case AES_CCM_16_128_128: 
            case AES_CCM_16_64_256: 
            case AES_CCM_16_128_256: 
            case AES_CCM_64_64_128: 
            case AES_CCM_64_128_128: 
            case AES_CCM_64_64_256: 
            case AES_CCM_64_128_256: {
                this.AES_CCM_Encrypt(alg, rgbKey);
                break;
            }
            case AES_GCM_128: 
            case AES_GCM_192: 
            case AES_GCM_256: {
                this.AES_GCM_Encrypt(alg, rgbKey);
                break;
            }
            case CHACHA20_POLY1305: {
                this.ChaCha20_Poly1305_Encrypt(alg, rgbKey);
                break;
            }
        }
    }

    private byte[] getAADBytes() {
        CBORObject obj = CBORObject.NewArray();
        obj.Add(this.context);
        if (this.objProtected.size() == 0) {
            obj.Add(CBORObject.FromObject(Bytes.EMPTY));
        } else {
            obj.Add(this.objProtected.EncodeToBytes());
        }
        obj.Add(CBORObject.FromObject(this.externalData));
        return obj.EncodeToBytes();
    }

    private void AES_CCM_Decrypt(AlgorithmID alg, byte[] rgbKey) throws CoseException, IllegalStateException {
        CBORObject iv = this.findAttribute(HeaderKeys.IV);
        byte[] aad = this.getAADBytes();
        try {
            this.rgbContent = CCMBlockCipher.decrypt(new SecretKeySpec(rgbKey, AES_SPEC), iv.GetByteString(), aad, this.getEncryptedContent(), alg.getTagSize() / 8);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CoseException("Algorithm not supported", ex);
        }
        catch (InvalidKeyException ex) {
            if (ex.getMessage().equals("Illegal key size")) {
                throw new CoseException("Unsupported key size", ex);
            }
            throw new CoseException("Decryption failure", ex);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CoseException("Decryption failure", ex);
        }
    }

    private void AES_CCM_Encrypt(AlgorithmID alg, byte[] rgbKey) throws CoseException, IllegalStateException {
        CBORObject iv = this.findAttribute(HeaderKeys.IV);
        byte[] aad = this.getAADBytes();
        try {
            this.rgbEncrypt = CCMBlockCipher.encrypt(new SecretKeySpec(rgbKey, AES_SPEC), iv.GetByteString(), aad, this.GetContent(), alg.getTagSize() / 8);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CoseException("Algorithm not supported", ex);
        }
        catch (Exception ex) {
            throw new CoseException("Encryption failure", ex);
        }
    }

    private void AES_GCM_Decrypt(AlgorithmID alg, byte[] rgbKey) throws CoseException {
        CBORObject iv = this.findAttribute(HeaderKeys.IV);
        byte[] aad = this.getAADBytes();
        try {
            Cipher cipher = (Cipher)AES_GCM_CIPHER.currentWithCause();
            cipher.init(2, (Key)new SecretKeySpec(rgbKey, AES_SPEC), new GCMParameterSpec(alg.getTagSize(), iv.GetByteString()));
            cipher.updateAAD(aad);
            this.rgbContent = cipher.doFinal(this.rgbEncrypt);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CoseException("Algorithm not supported", ex);
        }
        catch (Exception ex) {
            throw new CoseException("Decryption failure", ex);
        }
    }

    private void AES_GCM_Encrypt(AlgorithmID alg, byte[] rgbKey) throws CoseException, IllegalStateException {
        CBORObject iv = this.findAttribute(HeaderKeys.IV);
        byte[] aad = this.getAADBytes();
        try {
            Cipher cipher = (Cipher)AES_GCM_CIPHER.currentWithCause();
            cipher.init(1, (Key)new SecretKeySpec(rgbKey, AES_SPEC), new GCMParameterSpec(alg.getTagSize(), iv.GetByteString()));
            cipher.updateAAD(aad);
            this.rgbEncrypt = cipher.doFinal(this.rgbContent);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CoseException("Algorithm not supported", ex);
        }
        catch (Exception ex) {
            throw new CoseException("Encryption failure", ex);
        }
    }

    private void ChaCha20_Poly1305_Decrypt(AlgorithmID alg, byte[] rgbKey) throws CoseException {
        byte[] aad = this.getAADBytes();
        CBORObject iv = this.findAttribute(HeaderKeys.IV);
        try {
            Cipher cipher = (Cipher)CHACHA_POLY_CIPHER.currentWithCause();
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv.GetByteString());
            SecretKeySpec keySpec = new SecretKeySpec(rgbKey, CHACHA_SPEC);
            cipher.init(2, (Key)keySpec, ivParameterSpec);
            cipher.updateAAD(aad);
            this.rgbContent = cipher.doFinal(this.rgbEncrypt);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CoseException("Algorithm not supported", ex);
        }
        catch (Exception ex) {
            throw new CoseException("Decryption failure", ex);
        }
    }

    private void ChaCha20_Poly1305_Encrypt(AlgorithmID alg, byte[] rgbKey) throws CoseException {
        byte[] aad = this.getAADBytes();
        CBORObject iv = this.findAttribute(HeaderKeys.IV);
        try {
            Cipher cipher = (Cipher)CHACHA_POLY_CIPHER.currentWithCause();
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv.GetByteString());
            SecretKeySpec keySpec = new SecretKeySpec(rgbKey, CHACHA_SPEC);
            cipher.init(1, (Key)keySpec, ivParameterSpec);
            cipher.updateAAD(aad);
            this.rgbEncrypt = cipher.doFinal(this.rgbContent);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CoseException("Algorithm not supported", ex);
        }
        catch (Exception ex) {
            throw new CoseException("Encryption failure", ex);
        }
    }

    public byte[] getEncryptedContent() throws CoseException {
        if (this.rgbEncrypt == null) {
            throw new CoseException("No Encrypted Content Specified");
        }
        return this.rgbEncrypt;
    }

    public void setEncryptedContent(byte[] rgb) {
        this.rgbEncrypt = rgb;
    }

    private void validateObjectState(byte[] rgbKey) throws CoseException {
        AlgorithmID alg = AlgorithmID.FromCBOR(this.findAttribute(HeaderKeys.Algorithm));
        int ivLen = EncryptCommon.getIvLength(alg);
        if (rgbKey.length != alg.getKeySize() / 8) {
            throw new CoseException("Key Size is incorrect");
        }
        if (ivLen == -1) {
            throw new CoseException("Unsupported Algorithm Specified");
        }
        CBORObject iv = this.findAttribute(HeaderKeys.IV);
        if (iv == null) {
            throw new CoseException("Missing IV during decryption");
        }
        if (iv.getType() != CBORType.ByteString) {
            throw new CoseException("IV is incorrectly formed");
        }
        if (iv.GetByteString().length != ivLen) {
            throw new CoseException("IV size is incorrect");
        }
    }

    public static int getIvLength(AlgorithmID alg) {
        switch (alg) {
            case AES_CCM_16_64_128: 
            case AES_CCM_16_128_128: 
            case AES_CCM_16_64_256: 
            case AES_CCM_16_128_256: {
                return 13;
            }
            case AES_CCM_64_64_128: 
            case AES_CCM_64_128_128: 
            case AES_CCM_64_64_256: 
            case AES_CCM_64_128_256: {
                return 7;
            }
            case AES_GCM_128: 
            case AES_GCM_192: 
            case AES_GCM_256: {
                return 12;
            }
            case CHACHA20_POLY1305: {
                return 12;
            }
        }
        return -1;
    }
}

