/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap.option;

import org.eclipse.californium.core.coap.MediaTypeRegistry;
import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.OptionNumberRegistry;
import org.eclipse.californium.core.coap.option.BaseOptionDefinition;
import org.eclipse.californium.core.coap.option.StandardOptionRegistry;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;

public class IntegerOption
extends Option {
    private final long value;
    private final int length;

    public IntegerOption(Definition definition, long value) {
        super(definition);
        this.value = value;
        this.length = Definition.getValueLength(value);
        definition.assertValue(value, this.length);
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public void writeTo(DatagramWriter writer) {
        writer.writeLong(this.value, this.getLength() * 8);
    }

    public int getIntegerValue() {
        return (int)this.value;
    }

    public long getLongValue() {
        return this.value;
    }

    @Override
    public String toValueString() {
        int iValue = this.getIntegerValue();
        if (StandardOptionRegistry.ACCEPT.equals(this.getDefinition()) || StandardOptionRegistry.CONTENT_FORMAT.equals(this.getDefinition())) {
            return "\"" + MediaTypeRegistry.toString(iValue) + "\"";
        }
        return Long.toString(this.getLongValue());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntegerOption)) {
            return false;
        }
        IntegerOption op = (IntegerOption)o;
        return this.value == op.value && this.getDefinition().equals(op.getDefinition());
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Long.hashCode(this.value);
    }

    public static class Definition
    extends BaseOptionDefinition {
        private static final int[] LENGTHS = new int[]{0, 8};

        public Definition(int number, String name) {
            this(number, name, true, LENGTHS);
        }

        public Definition(int number, String name, boolean singleValue) {
            this(number, name, singleValue, LENGTHS);
        }

        public Definition(int number, String name, boolean singleValue, int ... lengths) {
            super(number, name, singleValue, lengths == null ? LENGTHS : lengths);
        }

        @Override
        public OptionNumberRegistry.OptionFormat getFormat() {
            return OptionNumberRegistry.OptionFormat.INTEGER;
        }

        @Override
        public IntegerOption create(DatagramReader reader, int length) {
            if (reader == null) {
                throw new NullPointerException("Option " + this.getName() + " reader must not be null.");
            }
            return new IntegerOption(this, Definition.getLongValue(reader, length));
        }

        public IntegerOption create(long value) {
            return new IntegerOption(this, value);
        }

        public void assertValue(long value, int length) {
            this.assertValueLength(length);
        }

        public static long getLongValue(DatagramReader reader, int length) {
            if (reader == null) {
                throw new NullPointerException("Reader must not be null.");
            }
            if (length > 8) {
                throw new IllegalArgumentException("Long's length must not be more than 8!");
            }
            long ret = 0L;
            while (length-- > 0) {
                ret <<= 8;
                ret += (long)(reader.readNextByte() & 0xFF);
            }
            return ret;
        }

        public static int getIntegerValue(DatagramReader reader, int length) {
            if (reader == null) {
                throw new NullPointerException("Reader must not be null.");
            }
            if (length > 4) {
                throw new IllegalArgumentException("Integer's length must not be more than 4!");
            }
            int ret = 0;
            while (length-- > 0) {
                ret <<= 8;
                ret += reader.readNextByte() & 0xFF;
            }
            return ret;
        }

        public static int getValueLength(long value) {
            return (64 - Long.numberOfLeadingZeros(value) + 7) / 8;
        }
    }

    public static class RangeDefinition
    extends Definition {
        private final long min;
        private final long max;

        public RangeDefinition(int number, String name, long min, long max) {
            this(number, name, true, min, max);
        }

        public RangeDefinition(int number, String name, boolean singleValue, long min, long max) {
            super(number, name, singleValue, RangeDefinition.getValueLength(min), RangeDefinition.getValueLength(max));
            if (min <= max) {
                this.min = min;
                this.max = max;
            } else {
                this.min = max;
                this.max = min;
            }
        }

        @Override
        public void assertValue(long value, int length) {
            super.assertValue(value, length);
            if (value < this.min) {
                throw new IllegalArgumentException("Option " + this.getName() + " value " + value + " must be at least " + this.min + ".");
            }
            if (value > this.max) {
                throw new IllegalArgumentException("Option " + this.getName() + " value " + value + "  must be at most " + this.max + ".");
            }
        }
    }
}

