/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.io.Serializable;

public class ProtocolVersion
implements Comparable<ProtocolVersion>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int MAJOR_1 = 254;
    public static final int MINOR_2 = 253;
    public static final int MINOR_0 = 255;
    public static final ProtocolVersion VERSION_DTLS_1_2 = new ProtocolVersion(254, 253);
    public static final ProtocolVersion VERSION_DTLS_1_0 = new ProtocolVersion(254, 255);
    private final int minor;
    private final int major;

    private ProtocolVersion(int major, int minor) {
        this.minor = minor;
        this.major = major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMajor() {
        return this.major;
    }

    @Override
    public int compareTo(ProtocolVersion o) {
        if (this == o) {
            return 0;
        }
        if (this.major == o.getMajor()) {
            if (this.minor < o.getMinor()) {
                return 1;
            }
            if (this.minor > o.getMinor()) {
                return -1;
            }
            return 0;
        }
        if (this.major < o.getMajor()) {
            return 1;
        }
        return -1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtocolVersion)) {
            return false;
        }
        ProtocolVersion other = (ProtocolVersion)obj;
        return this.major == other.major && this.minor == other.minor;
    }

    public String toString() {
        return Integer.toString(255 - this.major) + "." + Integer.toString(255 - this.minor);
    }

    public static ProtocolVersion valueOf(int major, int minor) {
        if (major == 254 && minor == 253) {
            return VERSION_DTLS_1_2;
        }
        if (major == 254 && minor == 255) {
            return VERSION_DTLS_1_0;
        }
        return new ProtocolVersion(major, minor);
    }

    public static ProtocolVersion valueOf(String version) {
        String[] split = version.split("\\.");
        int major = 255 - Integer.parseInt(split[0]);
        int minor = 255 - Integer.parseInt(split[1]);
        return ProtocolVersion.valueOf(major, minor);
    }
}

