/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.crypto.SecretKey;
import org.eclipse.californium.core.CoapServer;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.core.server.EncryptedServersSerializationUtil;
import org.eclipse.californium.core.server.resources.MyIpResource;
import org.eclipse.californium.cose.AlgorithmID;
import org.eclipse.californium.elements.config.CertificateAuthenticationMode;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.config.SystemConfig;
import org.eclipse.californium.elements.config.TcpConfig;
import org.eclipse.californium.elements.config.TimeDefinition;
import org.eclipse.californium.elements.config.UdpConfig;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.ExecutorsUtil;
import org.eclipse.californium.elements.util.NamedThreadFactory;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.oscore.HashMapCtxDB;
import org.eclipse.californium.oscore.OSCoreCoapStackFactory;
import org.eclipse.californium.oscore.OSCoreCtx;
import org.eclipse.californium.oscore.OSException;
import org.eclipse.californium.plugtests.AbstractTestServer;
import org.eclipse.californium.plugtests.EndpointNetSocketObserver;
import org.eclipse.californium.plugtests.resources.Create;
import org.eclipse.californium.plugtests.resources.DefaultTest;
import org.eclipse.californium.plugtests.resources.Echo;
import org.eclipse.californium.plugtests.resources.Hono;
import org.eclipse.californium.plugtests.resources.Large;
import org.eclipse.californium.plugtests.resources.LargeCreate;
import org.eclipse.californium.plugtests.resources.LargePost;
import org.eclipse.californium.plugtests.resources.LargeSeparate;
import org.eclipse.californium.plugtests.resources.LargeUpdate;
import org.eclipse.californium.plugtests.resources.Link1;
import org.eclipse.californium.plugtests.resources.Link2;
import org.eclipse.californium.plugtests.resources.Link3;
import org.eclipse.californium.plugtests.resources.LocationQuery;
import org.eclipse.californium.plugtests.resources.LongPath;
import org.eclipse.californium.plugtests.resources.MultiFormat;
import org.eclipse.californium.plugtests.resources.MyContext;
import org.eclipse.californium.plugtests.resources.Observe;
import org.eclipse.californium.plugtests.resources.ObserveLarge;
import org.eclipse.californium.plugtests.resources.ObserveNon;
import org.eclipse.californium.plugtests.resources.ObservePumping;
import org.eclipse.californium.plugtests.resources.ObserveReset;
import org.eclipse.californium.plugtests.resources.Oscore;
import org.eclipse.californium.plugtests.resources.OscoreInfo;
import org.eclipse.californium.plugtests.resources.Path;
import org.eclipse.californium.plugtests.resources.Query;
import org.eclipse.californium.plugtests.resources.Separate;
import org.eclipse.californium.plugtests.resources.Shutdown;
import org.eclipse.californium.plugtests.resources.Validate;
import org.eclipse.californium.scandium.config.DtlsConfig;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.eclipse.californium.unixhealth.NetSocketHealthLogger;
import org.eclipse.californium.unixhealth.NetStatLogger;
import picocli.CommandLine;

public class PlugtestServer
extends AbstractTestServer {
    private static final File CONFIG_FILE;
    private static final String CONFIG_HEADER = "Californium CoAP Properties file for Plugtest Server";
    private static final int DEFAULT_MAX_RESOURCE_SIZE = 8192;
    private static final int DEFAULT_BLOCK_SIZE = 64;
    private static final int DEFAULT_NOTIFY_INTERVAL_MILLIS = 5000;
    private static final int MINIMUM_NOTIFY_INTERVAL_MILLIS = 5;
    public static final int ERR_INIT_FAILED = 1;
    public static final List<CipherSuite> PRESELECTED_CIPHER_SUITES;
    private static Configuration.DefinitionsProvider DEFAULTS;
    private static final Config config;
    private static PlugtestServer server;
    private static EncryptedServersSerializationUtil serversSerialization;
    private static byte[] state;
    public static final String CALIFORNIUM_BUILD_VERSION;

    public static void main(String[] args) {
        CommandLine cmd = new CommandLine(config);
        try {
            CommandLine.ParseResult result = cmd.parseArgs(args);
            if (result.isVersionHelpRequested()) {
                String version = StringUtil.CALIFORNIUM_VERSION == null ? "" : StringUtil.CALIFORNIUM_VERSION;
                System.out.println("\nCalifornium (Cf) " + cmd.getCommandName() + " " + version);
                cmd.printVersionHelp(System.out);
                System.out.println();
            }
            if (result.isUsageHelpRequested()) {
                cmd.usage(System.out);
                return;
            }
        }
        catch (CommandLine.ParameterException ex) {
            System.err.println(ex.getMessage());
            System.err.println();
            cmd.usage(System.err);
            System.exit(-1);
        }
        Configuration configuration = PlugtestServer.init(config);
        PlugtestServer.load(config);
        ScheduledExecutorService executor = ExecutorsUtil.newScheduledThreadPool(configuration.get(CoapConfig.PROTOCOL_STAGE_THREAD_COUNT), new NamedThreadFactory("CoapServer(main)#"));
        ScheduledThreadPoolExecutor secondaryExecutor = ExecutorsUtil.newDefaultSecondaryScheduler("CoapServer(secondary)#");
        EndpointNetSocketObserver socketObserver = null;
        final NetSocketHealthLogger socketLogger = new NetSocketHealthLogger("udp");
        long interval = configuration.get(SystemConfig.HEALTH_STATUS_INTERVAL, TimeUnit.MILLISECONDS);
        if (interval > 0L && socketLogger.isEnabled()) {
            long readInterval = configuration.get(UDP_DROPS_READ_INTERVAL, TimeUnit.MILLISECONDS);
            if (interval > readInterval) {
                secondaryExecutor.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        socketLogger.read();
                    }
                }, readInterval, readInterval, TimeUnit.MILLISECONDS);
            }
            socketObserver = new EndpointNetSocketObserver(socketLogger);
        }
        PlugtestServer.start(executor, secondaryExecutor, config, configuration, socketObserver, new ActiveInputReader());
        LOGGER.info("Executor shutdown ...");
        ExecutorsUtil.shutdownExecutorGracefully(500L, executor, secondaryExecutor);
        PlugtestServer.exit();
        LOGGER.info("Exit ...");
    }

    public static void exit() {
        int count = Thread.activeCount();
        while (count > 0) {
            int size = Thread.activeCount();
            Thread[] all = new Thread[size];
            int available = Thread.enumerate(all);
            if (available < size) {
                size = available;
            }
            count = 0;
            for (int index = 0; index < size; ++index) {
                Thread thread = all[index];
                if (thread.isDaemon() || !thread.isAlive()) continue;
                ++count;
                LOGGER.info("Thread [{}] {}", (Object)thread.getId(), (Object)thread.getName());
            }
            if (count == 1) break;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    public static Configuration init(BaseConfig config) {
        Configuration configuration = Configuration.createWithFile(CONFIG_FILE, CONFIG_HEADER, DEFAULTS);
        Configuration udpConfiguration = new Configuration(configuration).set(CoapConfig.MAX_MESSAGE_SIZE, configuration.get(EXTERNAL_UDP_MAX_MESSAGE_SIZE)).set(CoapConfig.PREFERRED_BLOCK_SIZE, configuration.get(EXTERNAL_UDP_PREFERRED_BLOCK_SIZE));
        HashMap<AbstractTestServer.Select, Configuration> protocolConfig = new HashMap<AbstractTestServer.Select, Configuration>();
        protocolConfig.put(new AbstractTestServer.Select(AbstractTestServer.Protocol.UDP, AbstractTestServer.InterfaceType.EXTERNAL), udpConfiguration);
        try {
            HashMapCtxDB oscoreCtxDb = null;
            byte[] oscoreServerRid = null;
            if (config.oscore) {
                oscoreCtxDb = new HashMapCtxDB();
                OSCoreCoapStackFactory.useAsDefault(oscoreCtxDb);
                oscoreServerRid = PlugtestServer.initOscore(configuration, oscoreCtxDb);
            }
            long notifyIntervalMillis = 5000L;
            if (config.notifyInterval != null && (notifyIntervalMillis = TimeUnit.NANOSECONDS.toMillis(TimeDefinition.parse(config.notifyInterval))) < 5L) {
                notifyIntervalMillis = 5L;
            }
            List<AbstractTestServer.Protocol> protocols = config.getProtocols();
            List<AbstractTestServer.InterfaceType> types = config.getInterfaceTypes();
            server = new PlugtestServer(configuration, protocolConfig, notifyIntervalMillis, oscoreCtxDb, oscoreServerRid);
            server.setVersion(CALIFORNIUM_BUILD_VERSION);
            server.setTag("PLUG-TEST");
            PlugtestServer.add(server);
            server.addEndpoints(config.interfacePatterns, types, protocols, config);
            if (server.getEndpoints().isEmpty()) {
                System.err.println("no endpoint available!");
                System.exit(1);
            }
        }
        catch (Exception e) {
            System.err.printf("Failed to create " + PlugtestServer.class.getSimpleName() + ": %s\n", e.getMessage());
            e.printStackTrace(System.err);
            System.err.println("Exiting");
            System.exit(1);
        }
        return configuration;
    }

    public static void add(CoapServer server) {
        serversSerialization.add(server);
    }

    public static void load(BaseConfig config) {
        if (config.store != null) {
            serversSerialization.loadAndRegisterShutdown(config.store.file, config.store.password64.toCharArray(), TimeUnit.HOURS.toSeconds(config.store.maxAge.intValue()));
        }
    }

    public static void load(String password) {
        if (state != null) {
            SecretKey key = PlugtestServer.toKey(password);
            ByteArrayInputStream in = new ByteArrayInputStream(state);
            serversSerialization.loadServers(in, key);
            if (key == null) {
                LOGGER.info("Loaded: {} Bytes", (Object)state.length);
            } else {
                LOGGER.info("Loaded: {} Bytes (pw: {})", (Object)state.length, (Object)password);
            }
            state = null;
            serversSerialization.start();
            SecretUtil.destroy(key);
            try {
                in.close();
            }
            catch (IOException iOException) {}
        } else {
            LOGGER.info("no data to load!");
        }
    }

    public static void start(ScheduledExecutorService mainExecutor, ScheduledExecutorService secondaryExecutor, BaseConfig config, Configuration configuration, EndpointNetSocketObserver observer, ActiveInputReader inputReader) {
        if (server != null) {
            server.setExecutors(mainExecutor, secondaryExecutor, true);
            if (observer != null) {
                server.addDefaultEndpointObserver(observer);
            }
            server.add(new Echo(configuration.get(CoapConfig.MAX_RESOURCE_BODY_SIZE), config.echoDelay ? mainExecutor : null));
            server.start();
            server.addLogger(true);
            LOGGER.info("{} started ...", (Object)PlugtestServer.class.getSimpleName());
            if (inputReader != null) {
                long interval = configuration.get(SystemConfig.HEALTH_STATUS_INTERVAL, TimeUnit.MILLISECONDS);
                if (interval > 0L) {
                    if (observer != null) {
                        server.add(observer.getNetSocketHealth());
                    }
                    if (config.ipv4) {
                        server.add(new NetStatLogger("udp", false));
                    }
                    if (config.ipv6) {
                        server.add(new NetStatLogger("udp6", true));
                    }
                } else {
                    interval = 30000L;
                }
                while (!PlugtestServer.console(inputReader, interval)) {
                    server.dump();
                }
                LOGGER.info("{} stopping ...", (Object)PlugtestServer.class.getSimpleName());
                PlugtestServer.shutdown();
            }
        }
    }

    public static void shutdown() {
        if (server != null) {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(String password) {
        SecretKey key = PlugtestServer.toKey(password);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (state != null) {
            Bytes.clear(state);
        }
        try {
            serversSerialization.saveServers(out, key, 600L);
            state = out.toByteArray();
            out.close();
            if (key == null) {
                LOGGER.info("Saved: {} Bytes", (Object)state.length);
            } else {
                LOGGER.info("Saved: {} Bytes (pw: {})", (Object)state.length, (Object)password);
            }
        }
        catch (IOException ex) {
            LOGGER.warn("saving failed:", ex);
        }
        finally {
            SecretUtil.destroy(key);
        }
    }

    public static SecretKey toKey(String password) {
        SecretKey key = null;
        if (password != null && !password.isEmpty()) {
            key = SecretUtil.create(password.getBytes(), "PW");
        }
        return key;
    }

    public static boolean console(ActiveInputReader reader, long timeout) {
        try {
            String line = reader.getLine(timeout);
            if (line != null) {
                System.out.println("> " + line);
                if (line.startsWith("save")) {
                    PlugtestServer.save(line.substring(4));
                } else if (line.startsWith("load")) {
                    PlugtestServer.load(line.substring(4));
                } else if (line.equals("exit")) {
                    return true;
                }
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            return true;
        }
        return false;
    }

    public static byte[] initOscore(Configuration config, HashMapCtxDB db) {
        AlgorithmID alg = AlgorithmID.AES_CCM_16_64_128;
        AlgorithmID kdf = AlgorithmID.HKDF_HMAC_SHA_256;
        byte[] master_secret = StringUtil.hex2ByteArray("0102030405060708090a0b0c0d0e0f10");
        byte[] master_salt = StringUtil.hex2ByteArray("9e7ca92223786340");
        byte[] sid = StringUtil.hex2ByteArray("02");
        byte[] rid = StringUtil.hex2ByteArray("01");
        byte[] id_context = StringUtil.hex2ByteArray("37cbf3210017a2d3");
        int MAX_UNFRAGMENTED_SIZE = config.get(CoapConfig.MAX_RESOURCE_BODY_SIZE);
        OSCoreCtx ctx = null;
        try {
            ctx = new OSCoreCtx(master_secret, false, alg, sid, rid, kdf, 32, master_salt, id_context, MAX_UNFRAGMENTED_SIZE);
            ctx.setContextRederivationEnabled(true);
        }
        catch (OSException e) {
            LOGGER.error("Failed to derive OSCORE context");
            e.printStackTrace();
        }
        db.addContext(ctx);
        return rid;
    }

    public PlugtestServer(Configuration config, Map<AbstractTestServer.Select, Configuration> protocolConfig, long notifyIntervalMillis, HashMapCtxDB oscoreCtxDb, byte[] oscoreServerRid) throws SocketException {
        super(config, protocolConfig);
        this.add(new DefaultTest());
        this.add(new LongPath());
        this.add(new Query());
        this.add(new Separate());
        this.add(new Large());
        this.add(new LargeUpdate());
        this.add(new LargeCreate());
        this.add(new LargePost());
        this.add(new LargeSeparate());
        this.add(new Observe(notifyIntervalMillis));
        this.add(new ObserveNon(notifyIntervalMillis));
        this.add(new ObserveReset());
        this.add(new ObserveLarge(notifyIntervalMillis));
        this.add(new ObservePumping(CoAP.Type.CON, notifyIntervalMillis));
        this.add(new ObservePumping(CoAP.Type.NON, notifyIntervalMillis));
        this.add(new LocationQuery());
        this.add(new MultiFormat());
        this.add(new Link1());
        this.add(new Link2());
        this.add(new Link3());
        this.add(new Path());
        this.add(new Validate());
        this.add(new Create());
        this.add(new Shutdown());
        this.add(new Hono("telemetry"));
        this.add(new Hono("event"));
        this.add(new MyIpResource("myip", false));
        this.add(new MyContext("mycontext", CALIFORNIUM_BUILD_VERSION, false));
        if (oscoreCtxDb != null && oscoreServerRid != null) {
            this.add(new Oscore());
            this.add(new OscoreInfo(oscoreCtxDb, oscoreServerRid));
        }
    }

    static {
        CoapConfig.register();
        UdpConfig.register();
        DtlsConfig.register();
        TcpConfig.register();
        CONFIG_FILE = new File("CaliforniumPlugtest3.properties");
        PRESELECTED_CIPHER_SUITES = Arrays.asList(CipherSuite.TLS_PSK_WITH_AES_128_CCM_8, CipherSuite.TLS_ECDHE_PSK_WITH_AES_128_CCM_8_SHA256, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8, CipherSuite.TLS_PSK_WITH_AES_128_CBC_SHA256, CipherSuite.TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256, CipherSuite.TLS_PSK_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256);
        DEFAULTS = new Configuration.DefinitionsProvider(){

            @Override
            public void applyDefinitions(Configuration config) {
                config.set(SystemConfig.HEALTH_STATUS_INTERVAL, 300, TimeUnit.SECONDS);
                config.set(CoapConfig.MAX_RESOURCE_BODY_SIZE, 8192);
                config.set(CoapConfig.MAX_MESSAGE_SIZE, 64);
                config.set(CoapConfig.PREFERRED_BLOCK_SIZE, 64);
                config.set(CoapConfig.NOTIFICATION_CHECK_INTERVAL_COUNT, 4);
                config.set(CoapConfig.NOTIFICATION_CHECK_INTERVAL_TIME, 30, TimeUnit.SECONDS);
                config.set(CoapConfig.TCP_NUMBER_OF_BULK_BLOCKS, 1);
                config.set(CoapConfig.MAX_ACTIVE_PEERS, 10000);
                config.set(DtlsConfig.DTLS_RECOMMENDED_CIPHER_SUITES_ONLY, false);
                config.set(DtlsConfig.DTLS_AUTO_HANDSHAKE_TIMEOUT, null, TimeUnit.SECONDS);
                config.set(DtlsConfig.DTLS_CONNECTION_ID_LENGTH, 6);
                config.set(DtlsConfig.DTLS_SUPPORT_DEPRECATED_CID, true);
                config.set(DtlsConfig.DTLS_PRESELECTED_CIPHER_SUITES, PRESELECTED_CIPHER_SUITES);
                config.set(DtlsConfig.DTLS_MAX_CONNECTIONS, 10000);
                config.set(DtlsConfig.DTLS_READ_WRITE_LOCK_CONNECTION_STORE, false);
                config.set(DtlsConfig.DTLS_REMOVE_STALE_DOUBLE_PRINCIPALS, false);
                config.set(AbstractTestServer.EXTERNAL_UDP_MAX_MESSAGE_SIZE, 64);
                config.set(AbstractTestServer.EXTERNAL_UDP_PREFERRED_BLOCK_SIZE, 64);
                config.set(AbstractTestServer.UDP_DROPS_READ_INTERVAL, 2000, TimeUnit.MILLISECONDS);
            }
        };
        config = new Config();
        serversSerialization = new EncryptedServersSerializationUtil();
        String version = StringUtil.CALIFORNIUM_VERSION;
        if (version != null) {
            String build = StringUtil.readFile(new File("build"), null);
            if (build != null && !build.isEmpty()) {
                version = version + "_" + build;
            }
        } else {
            version = "";
        }
        CALIFORNIUM_BUILD_VERSION = version;
    }

    public static class ActiveInputReader {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        Queue<String> buffer = new ConcurrentLinkedQueue<String>();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                ActiveInputReader.this.read();
            }
        }, "INPUT");

        public ActiveInputReader() {
            this.thread.setDaemon(true);
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void read() {
            String line = null;
            try {
                while ((line = this.in.readLine()) != null) {
                    this.buffer.add(line);
                    Queue<String> queue = this.buffer;
                    synchronized (queue) {
                        this.buffer.notify();
                    }
                }
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getLine(long timeout) throws InterruptedException {
            if (timeout >= 0L) {
                Queue<String> queue = this.buffer;
                synchronized (queue) {
                    this.buffer.wait(timeout);
                }
            }
            return this.buffer.poll();
        }
    }

    @CommandLine.Command(name="PlugtestServer", version={"(c) 2014, Institute for Pervasive Computing, ETH Zurich."})
    public static class Config
    extends BaseConfig {
    }

    public static class BaseConfig {
        @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"display a help message"})
        public boolean helpRequested;
        @CommandLine.Option(names={"--no-loopback"}, negatable=true, description={"enable endpoints on loopback network."})
        public boolean loopback = true;
        @CommandLine.Option(names={"--no-external"}, negatable=true, description={"enable endpoints on external network."})
        public boolean external = true;
        @CommandLine.Option(names={"--no-ipv4"}, negatable=true, description={"enable endpoints for ipv4."})
        public boolean ipv4 = true;
        @CommandLine.Option(names={"--no-ipv6"}, negatable=true, description={"enable endpoints for ipv6."})
        public boolean ipv6 = true;
        @CommandLine.Option(names={"--no-tcp"}, negatable=true, description={"enable endpoints for tcp."})
        public boolean tcp = true;
        @CommandLine.Option(names={"--dtls-only"}, description={"only dtls endpoints."})
        public boolean onlyDtls;
        @CommandLine.Option(names={"--trust-all"}, description={"trust all valid certificates."})
        public boolean trustall;
        @CommandLine.Option(names={"--client-auth"}, description={"client authentication. Values ${COMPLETION-CANDIDATES}."})
        public CertificateAuthenticationMode clientAuth;
        @CommandLine.Option(names={"--interfaces-pattern"}, split=",", description={"interface regex patterns for endpoints."})
        public List<String> interfacePatterns;
        @CommandLine.Option(names={"--echo-delay"}, negatable=true, description={"enable delay option for echo resource."})
        public boolean echoDelay;
        @CommandLine.Option(names={"--no-oscore"}, negatable=true, description={"use OSCORE."})
        public boolean oscore = true;
        @CommandLine.Option(names={"--notify-interval"}, description={"Interval for plugtest notifies. e.g. 5[s]. Minimum 5[ms], default 5000[ms]."})
        public String notifyInterval;
        @CommandLine.ArgGroup(exclusive=false)
        public Store store;

        public List<AbstractTestServer.Protocol> getProtocols() {
            ArrayList<AbstractTestServer.Protocol> protocols = new ArrayList<AbstractTestServer.Protocol>();
            protocols.add(AbstractTestServer.Protocol.DTLS);
            if (!this.onlyDtls) {
                protocols.add(AbstractTestServer.Protocol.UDP);
                if (this.tcp) {
                    protocols.add(AbstractTestServer.Protocol.TCP);
                    protocols.add(AbstractTestServer.Protocol.TLS);
                }
            } else {
                this.tcp = false;
            }
            return protocols;
        }

        public List<AbstractTestServer.InterfaceType> getInterfaceTypes() {
            int s;
            ArrayList<AbstractTestServer.InterfaceType> types = new ArrayList<AbstractTestServer.InterfaceType>();
            if (this.external) {
                types.add(AbstractTestServer.InterfaceType.EXTERNAL);
            }
            if (this.loopback) {
                types.add(AbstractTestServer.InterfaceType.LOCAL);
            }
            if ((s = types.size()) == 0) {
                System.err.println("Either --loopback or --external must be enabled!");
                System.exit(1);
            }
            if (this.ipv6) {
                types.add(AbstractTestServer.InterfaceType.IPV6);
            }
            if (this.ipv4) {
                types.add(AbstractTestServer.InterfaceType.IPV4);
            }
            if (s == types.size()) {
                System.err.println("Either --ipv4 or --ipv6 must be enabled!");
            }
            return types;
        }

        public static class Store {
            @CommandLine.Option(names={"--store-file"}, required=true, description={"file store dtls state."})
            public String file;
            @CommandLine.Option(names={"--store-password64"}, required=false, description={"password to store dtls state. base 64 encoded."})
            public String password64;
            @CommandLine.Option(names={"--store-max-age"}, required=true, description={"maximum age of connections in hours."})
            public Integer maxAge;
        }
    }
}

