/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.oscore;

import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.cose.Encrypt0Message;
import org.eclipse.californium.oscore.ContextRederivation;
import org.eclipse.californium.oscore.Encryptor;
import org.eclipse.californium.oscore.OSCoreCtx;
import org.eclipse.californium.oscore.OSCoreCtxDB;
import org.eclipse.californium.oscore.OSException;
import org.eclipse.californium.oscore.OSSerializer;
import org.eclipse.californium.oscore.OptionJuggle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestEncryptor
extends Encryptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestEncryptor.class);

    public static Request encrypt(OSCoreCtxDB db, Request request) throws OSException {
        String uri = request.getOptions().hasProxyUri() ? request.getOptions().getProxyUri() : request.getURI();
        OSCoreCtx ctx = db.getContext(uri);
        if (ctx == null) {
            LOGGER.error("Context is null");
            throw new OSException("Context is null");
        }
        try {
            ctx = ContextRederivation.outgoingRequest(db, ctx);
        }
        catch (OSException e) {
            LOGGER.error("Security context re-generation failed");
            throw new OSException("Security context re-generation failed");
        }
        int realCode = request.getCode().value;
        request = OptionJuggle.setFakeCodeRequest(request);
        OptionSet options = request.getOptions();
        byte[] confidential = OSSerializer.serializeConfidentialData(options, request.getPayload(), realCode);
        Encrypt0Message enc = RequestEncryptor.prepareCOSEStructure(confidential);
        byte[] cipherText = RequestEncryptor.encryptAndEncode(enc, ctx, request, false, null);
        RequestEncryptor.compression(ctx, cipherText, request, false);
        request.setOptions(OptionJuggle.prepareUoptions(request.getOptions()));
        ctx.increaseSenderSeq();
        return request;
    }
}

