/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests.resources;

import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.LinkFormat;
import org.eclipse.californium.core.coap.MediaTypeRegistry;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.californium.elements.util.Bytes;

public class LargeCreate
extends CoapResource {
    private int counter = 0;

    public LargeCreate() {
        this("large-create");
    }

    public LargeCreate(String resourceIdentifier) {
        super(resourceIdentifier);
        this.getAttributes().setTitle("Large resource that can be created using POST method");
        this.getAttributes().addResourceType("block");
    }

    @Override
    public void handleGET(CoapExchange exchange) {
        String subtree = LinkFormat.serializeTree(this);
        exchange.respond(CoAP.ResponseCode.CONTENT, subtree, 40);
    }

    @Override
    public void handlePOST(CoapExchange exchange) {
        if (exchange.getRequestOptions().hasContentFormat()) {
            exchange.setLocationPath(this.storeData(exchange.getRequestPayload(), exchange.getRequestOptions().getContentFormat()));
            exchange.respond(CoAP.ResponseCode.CREATED);
        } else {
            exchange.respond(CoAP.ResponseCode.BAD_REQUEST, "Content-Format not set");
        }
    }

    private synchronized String storeData(byte[] payload, int cf) {
        String name = new Integer(++this.counter).toString();
        StorageResource sub = new StorageResource(name, payload, cf);
        this.add((CoapResource)sub);
        return sub.getURI();
    }

    private class StorageResource
    extends CoapResource {
        byte[] data;
        int dataCt;

        public StorageResource(String name, byte[] post, int ct) {
            super(name);
            this.data = null;
            this.dataCt = -1;
            this.data = post != null ? post : Bytes.EMPTY;
            this.dataCt = ct;
            this.getAttributes().addContentType(this.dataCt);
            this.getAttributes().setMaximumSizeEstimate(this.data.length);
        }

        @Override
        public void handleGET(CoapExchange exchange) {
            if (exchange.getRequestOptions().hasAccept() && exchange.getRequestOptions().getAccept() != this.dataCt) {
                exchange.respond(CoAP.ResponseCode.NOT_ACCEPTABLE, MediaTypeRegistry.toString(this.dataCt) + " only");
            } else {
                exchange.respond(CoAP.ResponseCode.CONTENT, this.data, this.dataCt);
            }
        }

        @Override
        public void handleDELETE(CoapExchange exchange) {
            this.delete();
            exchange.respond(CoAP.ResponseCode.DELETED);
        }
    }
}

