/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.config;

import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.ValueException;

public class DoubleDefinition
extends BasicDefinition<Double> {
    private final Double minimumValue;

    public DoubleDefinition(String key, String documentation) {
        super(key, documentation, Double.class);
        this.minimumValue = null;
    }

    public DoubleDefinition(String key, String documentation, Double defaultValue) {
        super(key, documentation, Double.class, defaultValue);
        this.minimumValue = null;
    }

    public DoubleDefinition(String key, String documentation, Double defaultValue, Double minimumValue) {
        super(key, documentation, Double.class, defaultValue);
        this.minimumValue = minimumValue;
    }

    @Override
    public String getTypeName() {
        return "Double";
    }

    @Override
    public String writeValue(Double value) {
        return value.toString();
    }

    @Override
    public Double checkValue(Double value) throws ValueException {
        if (this.minimumValue != null && value != null && value < this.minimumValue) {
            throw new ValueException("Value " + value + " must be not less than " + this.minimumValue + "!");
        }
        return value;
    }

    @Override
    protected Double parseValue(String value) {
        return Double.parseDouble(value);
    }
}

