/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.pskstore;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import org.eclipse.californium.elements.util.DaemonThreadFactory;
import org.eclipse.californium.elements.util.ExecutorsUtil;
import org.eclipse.californium.elements.util.NamedThreadFactory;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.HandshakeResultHandler;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;
import org.eclipse.californium.scandium.dtls.PskSecretResult;
import org.eclipse.californium.scandium.dtls.cipher.PseudoRandomFunction;
import org.eclipse.californium.scandium.dtls.cipher.ThreadLocalCryptoMap;
import org.eclipse.californium.scandium.dtls.cipher.ThreadLocalMac;
import org.eclipse.californium.scandium.dtls.pskstore.AdvancedPskStore;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.eclipse.californium.scandium.util.ServerNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncAdvancedPskStore
implements AdvancedPskStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncAdvancedPskStore.class);
    protected static final ThreadLocalCryptoMap<ThreadLocalMac> MAC = new ThreadLocalCryptoMap<ThreadLocalMac>(new ThreadLocalCryptoMap.Factory<ThreadLocalMac>(){

        @Override
        public ThreadLocalMac getInstance(String algorithm) {
            return new ThreadLocalMac(algorithm);
        }
    });
    private static final NamedThreadFactory THREAD_FACTORY = new DaemonThreadFactory("AsyncPskStoreTimer#");
    private final ScheduledExecutorService executorService;
    private final AdvancedPskStore pskStore;
    private volatile int delayMillis = 1;
    private volatile boolean generateMasterSecret;
    private volatile HandshakeResultHandler resultHandler;

    public AsyncAdvancedPskStore(AdvancedPskStore pskStore) {
        this.pskStore = pskStore;
        this.executorService = ExecutorsUtil.newSingleThreadScheduledExecutor(THREAD_FACTORY);
    }

    public AsyncAdvancedPskStore setSecretMode(boolean enableGenerateMasterSecret) {
        this.generateMasterSecret = enableGenerateMasterSecret;
        return this;
    }

    public AsyncAdvancedPskStore setDelay(int delayMillis) {
        this.delayMillis = delayMillis;
        if (delayMillis > 0) {
            LOGGER.info("Asynchronous delayed PSK store {}ms.", (Object)delayMillis);
        } else if (delayMillis < 0) {
            LOGGER.info("Synchronous delayed PSK store {}ms.", (Object)(-delayMillis));
        } else {
            LOGGER.info("Synchronous PSK store.");
        }
        return this;
    }

    public int getDelay() {
        return this.delayMillis;
    }

    public void shutdown() {
        this.executorService.shutdown();
    }

    @Override
    public PskSecretResult requestPskSecretResult(final ConnectionId cid, final ServerNames serverNames, final PskPublicInformation identity, final String hmacAlgorithm, SecretKey otherSecret, byte[] seed, final boolean useExtendedMasterSecret) {
        if (this.delayMillis <= 0) {
            if (this.delayMillis < 0) {
                try {
                    Thread.sleep(-this.delayMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.getPskSecretResult(cid, serverNames, identity, hmacAlgorithm, otherSecret, seed, useExtendedMasterSecret);
        }
        final byte[] randomSeed = Arrays.copyOf(seed, seed.length);
        final SecretKey other = SecretUtil.create(otherSecret);
        this.executorService.schedule(new Runnable(){

            @Override
            public void run() {
                AsyncAdvancedPskStore.this.getSecretAsynchronous(cid, serverNames, identity, hmacAlgorithm, other, randomSeed, useExtendedMasterSecret);
            }
        }, (long)this.delayMillis, TimeUnit.MILLISECONDS);
        return null;
    }

    private void getSecretAsynchronous(ConnectionId cid, ServerNames serverNames, PskPublicInformation identity, String hmacAlgorithm, SecretKey otherSecret, byte[] seed, boolean useExtendedMasterSecret) {
        PskSecretResult result = this.getPskSecretResult(cid, serverNames, identity, hmacAlgorithm, otherSecret, seed, useExtendedMasterSecret);
        this.resultHandler.apply(result);
    }

    private PskSecretResult getPskSecretResult(ConnectionId cid, ServerNames serverNames, PskPublicInformation identity, String hmacAlgorithm, SecretKey otherSecret, byte[] seed, boolean useExtendedMasterSecret) {
        PskSecretResult result = this.pskStore.requestPskSecretResult(cid, serverNames, identity, hmacAlgorithm, otherSecret, seed, useExtendedMasterSecret);
        if (this.generateMasterSecret && result.getSecret() != null && "PSK".equals(result.getSecret().getAlgorithm())) {
            SecretKey masterSecret = this.generateMasterSecret(hmacAlgorithm, result.getSecret(), otherSecret, seed, useExtendedMasterSecret);
            SecretUtil.destroy(result.getSecret());
            return new PskSecretResult(cid, result.getPskPublicInformation(), masterSecret);
        }
        return result;
    }

    protected SecretKey generateMasterSecret(String hmacAlgorithm, SecretKey pskSecret, SecretKey otherSecret, byte[] seed, boolean useExtendedMasterSecret) {
        ThreadLocalMac hmac = MAC.get(hmacAlgorithm);
        SecretKey premasterSecret = PseudoRandomFunction.generatePremasterSecretFromPSK(otherSecret, pskSecret);
        SecretKey masterSecret = PseudoRandomFunction.generateMasterSecret((Mac)hmac.current(), premasterSecret, seed, useExtendedMasterSecret);
        SecretUtil.destroy(premasterSecret);
        return masterSecret;
    }

    @Override
    public void setResultHandler(HandshakeResultHandler resultHandler) {
        if (this.resultHandler != null && resultHandler != null && this.resultHandler != resultHandler) {
            throw new IllegalStateException("handshake result handler already set!");
        }
        this.resultHandler = resultHandler;
    }

    @Override
    public boolean hasEcdhePskSupported() {
        return true;
    }

    @Override
    public PskPublicInformation getIdentity(InetSocketAddress peerAddress, ServerNames virtualHost) {
        return this.pskStore.getIdentity(peerAddress, virtualHost);
    }
}

